<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The level of protection offered as defined by [PayPal Seller Protection for Merchants](https://www.
 * paypal.com/us/webapps/mpp/security/seller-protection).
 */
class SellerProtection implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string[]|null
     */
    private $disputeCategories;

    /**
     * Returns Status.
     * Indicates whether the transaction is eligible for seller protection. For information, see [PayPal
     * Seller Protection for Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-protection).
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * Indicates whether the transaction is eligible for seller protection. For information, see [PayPal
     * Seller Protection for Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-protection).
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Dispute Categories.
     * An array of conditions that are covered for the transaction.
     *
     * @return string[]|null
     */
    public function getDisputeCategories(): ?array
    {
        return $this->disputeCategories;
    }

    /**
     * Sets Dispute Categories.
     * An array of conditions that are covered for the transaction.
     *
     * @maps dispute_categories
     *
     * @param string[]|null $disputeCategories
     */
    public function setDisputeCategories(?array $disputeCategories): void
    {
        $this->disputeCategories = $disputeCategories;
    }

    /**
     * Converts the SellerProtection object to a human-readable string representation.
     *
     * @return string The string representation of the SellerProtection object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SellerProtection',
            ['status' => $this->status, 'disputeCategories' => $this->disputeCategories]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->status)) {
            $json['status']             = $this->status;
        }
        if (isset($this->disputeCategories)) {
            $json['dispute_categories'] = $this->disputeCategories;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
