<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
 * backward compatibility only. Does not contain phone.
 */
class SimplePostalAddressCoarseGrained implements \JsonSerializable
{
    /**
     * @var string
     */
    private $line1;

    /**
     * @var string|null
     */
    private $line2;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string|null
     */
    private $state;

    /**
     * @var string
     */
    private $countryCode;

    /**
     * @var string|null
     */
    private $postalCode;

    /**
     * @param string $line1
     * @param string $city
     * @param string $countryCode
     */
    public function __construct(string $line1, string $city, string $countryCode)
    {
        $this->line1 = $line1;
        $this->city = $city;
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Line 1.
     * The first line of the address. For example, number or street.
     */
    public function getLine1(): string
    {
        return $this->line1;
    }

    /**
     * Sets Line 1.
     * The first line of the address. For example, number or street.
     *
     * @required
     * @maps line1
     */
    public function setLine1(string $line1): void
    {
        $this->line1 = $line1;
    }

    /**
     * Returns Line 2.
     * The second line of the address. For example, suite or apartment number.
     */
    public function getLine2(): ?string
    {
        return $this->line2;
    }

    /**
     * Sets Line 2.
     * The second line of the address. For example, suite or apartment number.
     *
     * @maps line2
     */
    public function setLine2(?string $line2): void
    {
        $this->line2 = $line2;
    }

    /**
     * Returns City.
     * The city name.
     */
    public function getCity(): string
    {
        return $this->city;
    }

    /**
     * Sets City.
     * The city name.
     *
     * @required
     * @maps city
     */
    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    /**
     * Returns State.
     * The [code](/docs/api/reference/state-codes/) for a US state or the equivalent for other countries.
     * Required for transactions if the address is in one of these countries:
     * [Argentina](/docs/api/reference/state-codes/#argentina), [Brazil](/docs/api/reference/state-
     * codes/#brazil), [Canada](/docs/api/reference/state-codes/#canada), [China](/docs/api/reference/state-
     * codes/#china), [India](/docs/api/reference/state-codes/#india), [Italy](/docs/api/reference/state-
     * codes/#italy), [Japan](/docs/api/reference/state-codes/#japan), [Mexico](/docs/api/reference/state-
     * codes/#mexico), [Thailand](/docs/api/reference/state-codes/#thailand), or [United
     * States](/docs/api/reference/state-codes/#usa). Maximum length is 40 single-byte characters.
     */
    public function getState(): ?string
    {
        return $this->state;
    }

    /**
     * Sets State.
     * The [code](/docs/api/reference/state-codes/) for a US state or the equivalent for other countries.
     * Required for transactions if the address is in one of these countries:
     * [Argentina](/docs/api/reference/state-codes/#argentina), [Brazil](/docs/api/reference/state-
     * codes/#brazil), [Canada](/docs/api/reference/state-codes/#canada), [China](/docs/api/reference/state-
     * codes/#china), [India](/docs/api/reference/state-codes/#india), [Italy](/docs/api/reference/state-
     * codes/#italy), [Japan](/docs/api/reference/state-codes/#japan), [Mexico](/docs/api/reference/state-
     * codes/#mexico), [Thailand](/docs/api/reference/state-codes/#thailand), or [United
     * States](/docs/api/reference/state-codes/#usa). Maximum length is 40 single-byte characters.
     *
     * @maps state
     */
    public function setState(?string $state): void
    {
        $this->state = $state;
    }

    /**
     * Returns Country Code.
     * The [two-character ISO 3166-1 code](/docs/integration/direct/rest/country-codes/) that identifies
     * the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-
     * level domain names for that country. Use the `C2` country code for China worldwide for comparable
     * uncontrolled price (CUP) method, bank card, and cross-border transactions.
     */
    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    /**
     * Sets Country Code.
     * The [two-character ISO 3166-1 code](/docs/integration/direct/rest/country-codes/) that identifies
     * the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-
     * level domain names for that country. Use the `C2` country code for China worldwide for comparable
     * uncontrolled price (CUP) method, bank card, and cross-border transactions.
     *
     * @required
     * @maps country_code
     */
    public function setCountryCode(string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Postal Code.
     * The postal code, which is the zip code or equivalent. Typically required for countries with a postal
     * code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     */
    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    /**
     * Sets Postal Code.
     * The postal code, which is the zip code or equivalent. Typically required for countries with a postal
     * code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     *
     * @maps postal_code
     */
    public function setPostalCode(?string $postalCode): void
    {
        $this->postalCode = $postalCode;
    }

    /**
     * Converts the SimplePostalAddressCoarseGrained object to a human-readable string representation.
     *
     * @return string The string representation of the SimplePostalAddressCoarseGrained object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SimplePostalAddressCoarseGrained',
            [
                'line1' => $this->line1,
                'line2' => $this->line2,
                'city' => $this->city,
                'state' => $this->state,
                'countryCode' => $this->countryCode,
                'postalCode' => $this->postalCode
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['line1']           = $this->line1;
        if (isset($this->line2)) {
            $json['line2']       = $this->line2;
        }
        $json['city']            = $this->city;
        if (isset($this->state)) {
            $json['state']       = $this->state;
        }
        $json['country_code']    = $this->countryCode;
        if (isset($this->postalCode)) {
            $json['postal_code'] = $this->postalCode;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
