<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The breakdown details for the amount. Includes the gross, tax, fee, and shipping amounts.
 */
class SubscriptionAmountWithBreakdown implements \JsonSerializable
{
    /**
     * @var Money
     */
    private $grossAmount;

    /**
     * @var Money|null
     */
    private $totalItemAmount;

    /**
     * @var Money|null
     */
    private $feeAmount;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var Money|null
     */
    private $taxAmount;

    /**
     * @var Money|null
     */
    private $netAmount;

    /**
     * @param Money $grossAmount
     */
    public function __construct(Money $grossAmount)
    {
        $this->grossAmount = $grossAmount;
    }

    /**
     * Returns Gross Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getGrossAmount(): Money
    {
        return $this->grossAmount;
    }

    /**
     * Sets Gross Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps gross_amount
     */
    public function setGrossAmount(Money $grossAmount): void
    {
        $this->grossAmount = $grossAmount;
    }

    /**
     * Returns Total Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTotalItemAmount(): ?Money
    {
        return $this->totalItemAmount;
    }

    /**
     * Sets Total Item Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps total_item_amount
     */
    public function setTotalItemAmount(?Money $totalItemAmount): void
    {
        $this->totalItemAmount = $totalItemAmount;
    }

    /**
     * Returns Fee Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getFeeAmount(): ?Money
    {
        return $this->feeAmount;
    }

    /**
     * Sets Fee Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps fee_amount
     */
    public function setFeeAmount(?Money $feeAmount): void
    {
        $this->feeAmount = $feeAmount;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTaxAmount(): ?Money
    {
        return $this->taxAmount;
    }

    /**
     * Sets Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps tax_amount
     */
    public function setTaxAmount(?Money $taxAmount): void
    {
        $this->taxAmount = $taxAmount;
    }

    /**
     * Returns Net Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getNetAmount(): ?Money
    {
        return $this->netAmount;
    }

    /**
     * Sets Net Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps net_amount
     */
    public function setNetAmount(?Money $netAmount): void
    {
        $this->netAmount = $netAmount;
    }

    /**
     * Converts the SubscriptionAmountWithBreakdown object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionAmountWithBreakdown object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionAmountWithBreakdown',
            [
                'grossAmount' => $this->grossAmount,
                'totalItemAmount' => $this->totalItemAmount,
                'feeAmount' => $this->feeAmount,
                'shippingAmount' => $this->shippingAmount,
                'taxAmount' => $this->taxAmount,
                'netAmount' => $this->netAmount
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['gross_amount']          = $this->grossAmount;
        if (isset($this->totalItemAmount)) {
            $json['total_item_amount'] = $this->totalItemAmount;
        }
        if (isset($this->feeAmount)) {
            $json['fee_amount']        = $this->feeAmount;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount']   = $this->shippingAmount;
        }
        if (isset($this->taxAmount)) {
            $json['tax_amount']        = $this->taxAmount;
        }
        if (isset($this->netAmount)) {
            $json['net_amount']        = $this->netAmount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
