<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Add pricing fields to exams table
    $pdo->exec("
        ALTER TABLE exams
        ADD COLUMN price DECIMAL(10,2) DEFAULT 0.00 AFTER total_points,
        ADD COLUMN currency VARCHAR(3) DEFAULT 'USD' AFTER price,
        ADD COLUMN is_free BOOLEAN DEFAULT TRUE AFTER currency
    ");

    // Add index for pricing queries
    $pdo->exec("CREATE INDEX idx_exams_price ON exams(price)");
    $pdo->exec("CREATE INDEX idx_exams_free ON exams(is_free)");

    echo "Exam pricing migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying exam pricing migration: " . $e->getMessage();
}
?>