<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Add topic_id column to course_lessons table
    $pdo->exec("
        ALTER TABLE course_lessons
        ADD COLUMN topic_id INT NULL AFTER module_id,
        ADD FOREIGN KEY (topic_id) REFERENCES course_topics(id) ON DELETE CASCADE
    ");

    // Add index for better performance
    $pdo->exec("CREATE INDEX idx_lessons_topic ON course_lessons (topic_id)");

    echo "Added topic_id to course_lessons migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying add topic_id to course_lessons migration: " . $e->getMessage();
}
?>