<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' - ' : ''; ?>Admin Panel | Mutalex Academy</title>
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Set up Tailwind configuration for professional color palette -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary-blue': '#1E3A8A',
                        'background-light': '#F8FAFC',
                        'text-dark': '#1F2937',
                        'accent-subtle': '#E5E7EB',
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
    <style>
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        ::-webkit-scrollbar-thumb {
            background-color: #D1D5DB;
            border-radius: 4px;
        }
        ::-webkit-scrollbar-track {
            background-color: transparent;
        }
        /* Smooth transitions */
        .transition-all {
            transition: all 0.3s ease;
        }
        /* Card hover effects */
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        /* List item styling */
        .list-item {
            transition: all 0.2s ease;
        }
        .list-item:hover {
            background-color: #f8fafc;
        }
    </style>
</head>
<body class="bg-background-light font-sans text-text-dark min-h-screen">

    <!-- Main Application Container -->
    <div id="app" class="flex">

        <!-- Top Bar (Mobile/Desktop Header) -->
        <header class="bg-white shadow-sm fixed top-0 left-0 right-0 z-10 border-b border-accent-subtle">
            <div class="px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center space-x-3">
                    <img src="../assets/images/logo_1757657555.jpg" alt="Mutalex Academy Logo" class="h-10 w-10">
                    <div>
                        <h1 class="text-xl font-bold text-primary-blue">Mutalex Academy</h1>
                        <p class="text-sm text-gray-600">Admin Panel</p>
                    </div>
                </div>

                <div class="flex items-center space-x-4">
                    <!-- Notifications -->
                    <button class="text-gray-600 hover:text-primary-blue p-2 rounded-full relative transition duration-150">
                        <i class="fas fa-bell"></i>
                    </button>

                    <!-- User Profile -->
                    <div class="flex items-center space-x-2">
                        <span class="text-sm font-medium hidden sm:inline"><?php echo htmlspecialchars($_SESSION['username'] ?? 'Admin'); ?></span>
                        <img class="h-10 w-10 rounded-full border-2 border-primary-blue object-cover" src="https://placehold.co/100x100/1E3A8A/ffffff?text=<?php echo substr(htmlspecialchars($_SESSION['username'] ?? 'A'), 0, 1); ?>" alt="User Avatar">
                    </div>
                </div>
            </div>
        </header>

        <!-- Sidebar Navigation (Desktop View) -->
        <aside class="hidden lg:block w-64 bg-white border-r border-accent-subtle p-6 shadow-sm sticky top-16 h-screen overflow-y-auto">
            <div class="flex flex-col h-full">
                <!-- Navigation Links -->
                <nav class="space-y-2 flex-grow">
                    <a href="dashboard.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-tachometer-alt w-5"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="analytics.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'analytics.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-chart-bar w-5"></i>
                        <span>Analytics</span>
                    </a>
                    <a href="users.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo in_array(basename($_SERVER['PHP_SELF']), ['users.php', 'user_create.php', 'user_edit.php', 'user_profile.php']) ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-users w-5"></i>
                        <span>User Management</span>
                    </a>
                    <a href="posts.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo in_array(basename($_SERVER['PHP_SELF']), ['posts.php', 'add_post.php', 'edit_post.php']) ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-file-alt w-5"></i>
                        <span>Posts</span>
                    </a>
                    <a href="categories.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-folder w-5"></i>
                        <span>Categories</span>
                    </a>
                    <a href="course_categories.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'course_categories.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-tags w-5"></i>
                        <span>Course Categories</span>
                    </a>
                    <a href="course_pricing.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'course_pricing.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-dollar-sign w-5"></i>
                        <span>Course Pricing</span>
                    </a>
                    <a href="exam_pricing.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'exam_pricing.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-file-invoice-dollar w-5"></i>
                        <span>Exam Pricing</span>
                    </a>
                    <a href="payment_gateways.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'payment_gateways.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-credit-card w-5"></i>
                        <span>Payment Settings</span>
                    </a>
                    <a href="announcements.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'announcements.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-bullhorn w-5"></i>
                        <span>Announcements</span>
                    </a>
                    <a href="calendar.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'calendar.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-calendar w-5"></i>
                        <span>Calendar Events</span>
                    </a>
                    <a href="roles.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'roles.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-shield-alt w-5"></i>
                        <span>Roles Management</span>
                    </a>
                    <a href="site_settings.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'site_settings.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-cogs w-5"></i>
                        <span>Site Settings</span>
                    </a>
                    <a href="logs.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'logs.php' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                        <i class="fas fa-history w-5"></i>
                        <span>System Audit Logs</span>
                    </a>
                    <a href="../home.php" class="flex items-center space-x-3 p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150" target="_blank">
                        <i class="fas fa-eye w-5"></i>
                        <span>View Site</span>
                    </a>
                    <a href="../logout.php" class="flex items-center space-x-3 p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">
                        <i class="fas fa-sign-out-alt w-5"></i>
                        <span>Logout</span>
                    </a>
                </nav>

                <!-- Footer/User Info (Bottom of Sidebar) -->
                <div class="mt-8 pt-4 border-t border-accent-subtle">
                    <p class="text-xs text-gray-500 mb-2">Authenticated User:</p>
                    <p class="text-xs text-gray-700 truncate font-mono bg-accent-subtle p-1 rounded"><?php echo htmlspecialchars($_SESSION['username'] ?? 'User'); ?></p>
                </div>
            </div>
        </aside>

        <!-- Main Content Area -->
        <main class="flex-1 overflow-y-auto pt-16 lg:pl-0">

            <!-- Page Header -->
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                <div class="bg-white p-6 rounded-xl shadow-lg border border-accent-subtle">
                    <h2 class="text-2xl font-bold text-primary-blue"><?php echo isset($page_title) ? htmlspecialchars($page_title) : 'Admin Panel'; ?></h2>
                </div>
            </div>

            <!-- Content Wrapper -->
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pb-8">
