<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Update the users table role enum
    $pdo->exec("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'instructor', 'student', 'guest') DEFAULT 'student'");

    // Update existing 'author' roles to 'instructor'
    $pdo->exec("UPDATE users SET role = 'instructor' WHERE role = 'author'");

    // Add additional columns for enhanced authentication
    $pdo->exec("ALTER TABLE users ADD COLUMN email_verified BOOLEAN DEFAULT FALSE");
    $pdo->exec("ALTER TABLE users ADD COLUMN email_verification_token VARCHAR(255) NULL");
    $pdo->exec("ALTER TABLE users ADD COLUMN password_reset_token VARCHAR(255) NULL");
    $pdo->exec("ALTER TABLE users ADD COLUMN password_reset_expires TIMESTAMP NULL");
    $pdo->exec("ALTER TABLE users ADD COLUMN last_login TIMESTAMP NULL");
    $pdo->exec("ALTER TABLE users ADD COLUMN failed_login_attempts INT DEFAULT 0");
    $pdo->exec("ALTER TABLE users ADD COLUMN account_locked_until TIMESTAMP NULL");
    $pdo->exec("ALTER TABLE users ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");

    echo "Full user migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying migration: " . $e->getMessage();
}
?>