<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Create course_enrollments table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS course_enrollments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            course_id INT NOT NULL,
            student_id INT NOT NULL,
            payment_status ENUM('pending', 'paid', 'failed', 'refunded') DEFAULT 'paid',
            payment_amount DECIMAL(10,2) DEFAULT 0.00,
            status ENUM('enrolled', 'in_progress', 'completed', 'dropped', 'active') DEFAULT 'active',
            enrollment_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            completion_date TIMESTAMP NULL,
            progress_percentage DECIMAL(5,2) DEFAULT 0.00,
            certificate_issued BOOLEAN DEFAULT FALSE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (course_id) REFERENCES courses(id) ON DELETE CASCADE,
            FOREIGN KEY (student_id) REFERENCES users(id) ON DELETE CASCADE,
            UNIQUE KEY unique_enrollment (course_id, student_id),
            INDEX idx_course (course_id),
            INDEX idx_student (student_id),
            INDEX idx_status (status),
            INDEX idx_payment_status (payment_status),
            INDEX idx_enrollment_date (enrollment_date)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    echo "Course enrollments migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying course enrollments migration: " . $e->getMessage();
}
?>