<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Create course_lesson_progress table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS course_lesson_progress (
            id INT AUTO_INCREMENT PRIMARY KEY,
            enrollment_id INT NOT NULL,
            lesson_id INT NOT NULL,
            status ENUM('not_started', 'in_progress', 'completed') DEFAULT 'not_started',
            progress_percentage DECIMAL(5,2) DEFAULT 0.00,
            time_spent INT DEFAULT 0, -- Time spent in seconds
            last_accessed TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            completed_at TIMESTAMP NULL,
            notes TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (enrollment_id) REFERENCES course_enrollments(id) ON DELETE CASCADE,
            FOREIGN KEY (lesson_id) REFERENCES course_lessons(id) ON DELETE CASCADE,
            UNIQUE KEY unique_progress (enrollment_id, lesson_id),
            INDEX idx_enrollment (enrollment_id),
            INDEX idx_lesson (lesson_id),
            INDEX idx_status (status),
            INDEX idx_last_accessed (last_accessed)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    echo "Course lesson progress migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying course lesson progress migration: " . $e->getMessage();
}
?>