<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Read the migration SQL file
    $migrationSQL = file_get_contents('supabase/migrations/20251123200000_add_question_bank_and_exam_tables.sql');

    // Split the SQL into individual statements
    $statements = array_filter(array_map('trim', explode(';', $migrationSQL)));

    foreach ($statements as $statement) {
        if (!empty($statement) && !preg_match('/^--/', $statement)) {
            $pdo->exec($statement);
            echo "Executed: " . substr($statement, 0, 50) . "...\n";
        }
    }

    echo "Questions migration applied successfully.\n";

} catch (PDOException $e) {
    echo "Error applying questions migration: " . $e->getMessage() . "\n";
}
?>