<?php
// Test checkout page loading
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    require_once '../includes/middleware.php';
    require_once '../config/database.php';
    require_once '../config/currency.php';
    require_once '../includes/functions.php';

    echo "All required files included successfully\n";

    $db = getDB();
    echo "Database connection: OK\n";

    // Check if user is logged in
    if (!isLoggedIn()) {
        echo "User not logged in - this would redirect to login\n";
    } else {
        echo "User is logged in\n";
        $userId = $_SESSION['user_id'];
        $user = getUserContext();
        echo "User ID: $userId, Username: " . ($user['username'] ?? 'N/A') . "\n";
    }

    echo "Checkout page test completed successfully\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>