<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardStoredCredential;
use PaypalServerSdkLib\Models\NetworkTransaction;

/**
 * Builder for model CardStoredCredential
 *
 * @see CardStoredCredential
 */
class CardStoredCredentialBuilder
{
    /**
     * @var CardStoredCredential
     */
    private $instance;

    private function __construct(CardStoredCredential $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Card Stored Credential Builder object.
     *
     * @param string $paymentInitiator
     * @param string $paymentType
     */
    public static function init(string $paymentInitiator, string $paymentType): self
    {
        return new self(new CardStoredCredential($paymentInitiator, $paymentType));
    }

    /**
     * Sets usage field.
     *
     * @param string|null $value
     */
    public function usage(?string $value): self
    {
        $this->instance->setUsage($value);
        return $this;
    }

    /**
     * Sets previous network transaction reference field.
     *
     * @param NetworkTransaction|null $value
     */
    public function previousNetworkTransactionReference(?NetworkTransaction $value): self
    {
        $this->instance->setPreviousNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Initializes a new Card Stored Credential object.
     */
    public function build(): CardStoredCredential
    {
        return CoreHelper::clone($this->instance);
    }
}
