<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Frequency;

/**
 * Builder for model Frequency
 *
 * @see Frequency
 */
class FrequencyBuilder
{
    /**
     * @var Frequency
     */
    private $instance;

    private function __construct(Frequency $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Frequency Builder object.
     *
     * @param string $intervalUnit
     */
    public static function init(string $intervalUnit): self
    {
        return new self(new Frequency($intervalUnit));
    }

    /**
     * Sets interval count field.
     *
     * @param int|null $value
     */
    public function intervalCount(?int $value): self
    {
        $this->instance->setIntervalCount($value);
        return $this;
    }

    /**
     * Initializes a new Frequency object.
     */
    public function build(): Frequency
    {
        return CoreHelper::clone($this->instance);
    }
}
