<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentInstruction;
use PaypalServerSdkLib\Models\PlatformFee;

/**
 * Builder for model PaymentInstruction
 *
 * @see PaymentInstruction
 */
class PaymentInstructionBuilder
{
    /**
     * @var PaymentInstruction
     */
    private $instance;

    private function __construct(PaymentInstruction $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Instruction Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentInstruction());
    }

    /**
     * Sets platform fees field.
     *
     * @param PlatformFee[]|null $value
     */
    public function platformFees(?array $value): self
    {
        $this->instance->setPlatformFees($value);
        return $this;
    }

    /**
     * Sets disbursement mode field.
     *
     * @param string|null $value
     */
    public function disbursementMode(?string $value): self
    {
        $this->instance->setDisbursementMode($value);
        return $this;
    }

    /**
     * Sets payee pricing tier id field.
     *
     * @param string|null $value
     */
    public function payeePricingTierId(?string $value): self
    {
        $this->instance->setPayeePricingTierId($value);
        return $this;
    }

    /**
     * Sets payee receivable fx rate id field.
     *
     * @param string|null $value
     */
    public function payeeReceivableFxRateId(?string $value): self
    {
        $this->instance->setPayeeReceivableFxRateId($value);
        return $this;
    }

    /**
     * Initializes a new Payment Instruction object.
     */
    public function build(): PaymentInstruction
    {
        return CoreHelper::clone($this->instance);
    }
}
