<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SepaDebitExperienceContext;
use PaypalServerSdkLib\Models\SepaDebitRequest;

/**
 * Builder for model SepaDebitRequest
 *
 * @see SepaDebitRequest
 */
class SepaDebitRequestBuilder
{
    /**
     * @var SepaDebitRequest
     */
    private $instance;

    private function __construct(SepaDebitRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Sepa Debit Request Builder object.
     */
    public static function init(): self
    {
        return new self(new SepaDebitRequest());
    }

    /**
     * Sets experience context field.
     *
     * @param SepaDebitExperienceContext|null $value
     */
    public function experienceContext(?SepaDebitExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new Sepa Debit Request object.
     */
    public function build(): SepaDebitRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
