<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\SubscriptionAmountWithBreakdown;

/**
 * Builder for model SubscriptionAmountWithBreakdown
 *
 * @see SubscriptionAmountWithBreakdown
 */
class SubscriptionAmountWithBreakdownBuilder
{
    /**
     * @var SubscriptionAmountWithBreakdown
     */
    private $instance;

    private function __construct(SubscriptionAmountWithBreakdown $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Amount With Breakdown Builder object.
     *
     * @param Money $grossAmount
     */
    public static function init(Money $grossAmount): self
    {
        return new self(new SubscriptionAmountWithBreakdown($grossAmount));
    }

    /**
     * Sets total item amount field.
     *
     * @param Money|null $value
     */
    public function totalItemAmount(?Money $value): self
    {
        $this->instance->setTotalItemAmount($value);
        return $this;
    }

    /**
     * Sets fee amount field.
     *
     * @param Money|null $value
     */
    public function feeAmount(?Money $value): self
    {
        $this->instance->setFeeAmount($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets tax amount field.
     *
     * @param Money|null $value
     */
    public function taxAmount(?Money $value): self
    {
        $this->instance->setTaxAmount($value);
        return $this;
    }

    /**
     * Sets net amount field.
     *
     * @param Money|null $value
     */
    public function netAmount(?Money $value): self
    {
        $this->instance->setNetAmount($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Amount With Breakdown object.
     */
    public function build(): SubscriptionAmountWithBreakdown
    {
        return CoreHelper::clone($this->instance);
    }
}
