<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Frequency;
use PaypalServerSdkLib\Models\SubscriptionBillingCycle;
use PaypalServerSdkLib\Models\SubscriptionPricingScheme;

/**
 * Builder for model SubscriptionBillingCycle
 *
 * @see SubscriptionBillingCycle
 */
class SubscriptionBillingCycleBuilder
{
    /**
     * @var SubscriptionBillingCycle
     */
    private $instance;

    private function __construct(SubscriptionBillingCycle $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Billing Cycle Builder object.
     *
     * @param Frequency $frequency
     * @param string $tenureType
     * @param int $sequence
     */
    public static function init(Frequency $frequency, string $tenureType, int $sequence): self
    {
        return new self(new SubscriptionBillingCycle($frequency, $tenureType, $sequence));
    }

    /**
     * Sets pricing scheme field.
     *
     * @param SubscriptionPricingScheme|null $value
     */
    public function pricingScheme(?SubscriptionPricingScheme $value): self
    {
        $this->instance->setPricingScheme($value);
        return $this;
    }

    /**
     * Sets total cycles field.
     *
     * @param int|null $value
     */
    public function totalCycles(?int $value): self
    {
        $this->instance->setTotalCycles($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Billing Cycle object.
     */
    public function build(): SubscriptionBillingCycle
    {
        return CoreHelper::clone($this->instance);
    }
}
