<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SubscriptionCardRequest;
use PaypalServerSdkLib\Models\SubscriptionPaymentSource;

/**
 * Builder for model SubscriptionPaymentSource
 *
 * @see SubscriptionPaymentSource
 */
class SubscriptionPaymentSourceBuilder
{
    /**
     * @var SubscriptionPaymentSource
     */
    private $instance;

    private function __construct(SubscriptionPaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Payment Source Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionPaymentSource());
    }

    /**
     * Sets card field.
     *
     * @param SubscriptionCardRequest|null $value
     */
    public function card(?SubscriptionCardRequest $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Payment Source object.
     */
    public function build(): SubscriptionPaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
