<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\TransactionInformation;

/**
 * Builder for model TransactionInformation
 *
 * @see TransactionInformation
 */
class TransactionInformationBuilder
{
    /**
     * @var TransactionInformation
     */
    private $instance;

    private function __construct(TransactionInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Transaction Information Builder object.
     */
    public static function init(): self
    {
        return new self(new TransactionInformation());
    }

    /**
     * Sets paypal account id field.
     *
     * @param string|null $value
     */
    public function paypalAccountId(?string $value): self
    {
        $this->instance->setPaypalAccountId($value);
        return $this;
    }

    /**
     * Sets transaction id field.
     *
     * @param string|null $value
     */
    public function transactionId(?string $value): self
    {
        $this->instance->setTransactionId($value);
        return $this;
    }

    /**
     * Sets paypal reference id field.
     *
     * @param string|null $value
     */
    public function paypalReferenceId(?string $value): self
    {
        $this->instance->setPaypalReferenceId($value);
        return $this;
    }

    /**
     * Sets paypal reference id type field.
     *
     * @param string|null $value
     */
    public function paypalReferenceIdType(?string $value): self
    {
        $this->instance->setPaypalReferenceIdType($value);
        return $this;
    }

    /**
     * Sets transaction event code field.
     *
     * @param string|null $value
     */
    public function transactionEventCode(?string $value): self
    {
        $this->instance->setTransactionEventCode($value);
        return $this;
    }

    /**
     * Sets transaction initiation date field.
     *
     * @param string|null $value
     */
    public function transactionInitiationDate(?string $value): self
    {
        $this->instance->setTransactionInitiationDate($value);
        return $this;
    }

    /**
     * Sets transaction updated date field.
     *
     * @param string|null $value
     */
    public function transactionUpdatedDate(?string $value): self
    {
        $this->instance->setTransactionUpdatedDate($value);
        return $this;
    }

    /**
     * Sets transaction amount field.
     *
     * @param Money|null $value
     */
    public function transactionAmount(?Money $value): self
    {
        $this->instance->setTransactionAmount($value);
        return $this;
    }

    /**
     * Sets fee amount field.
     *
     * @param Money|null $value
     */
    public function feeAmount(?Money $value): self
    {
        $this->instance->setFeeAmount($value);
        return $this;
    }

    /**
     * Sets discount amount field.
     *
     * @param Money|null $value
     */
    public function discountAmount(?Money $value): self
    {
        $this->instance->setDiscountAmount($value);
        return $this;
    }

    /**
     * Sets insurance amount field.
     *
     * @param Money|null $value
     */
    public function insuranceAmount(?Money $value): self
    {
        $this->instance->setInsuranceAmount($value);
        return $this;
    }

    /**
     * Sets sales tax amount field.
     *
     * @param Money|null $value
     */
    public function salesTaxAmount(?Money $value): self
    {
        $this->instance->setSalesTaxAmount($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets shipping discount amount field.
     *
     * @param Money|null $value
     */
    public function shippingDiscountAmount(?Money $value): self
    {
        $this->instance->setShippingDiscountAmount($value);
        return $this;
    }

    /**
     * Sets shipping tax amount field.
     *
     * @param Money|null $value
     */
    public function shippingTaxAmount(?Money $value): self
    {
        $this->instance->setShippingTaxAmount($value);
        return $this;
    }

    /**
     * Sets other amount field.
     *
     * @param Money|null $value
     */
    public function otherAmount(?Money $value): self
    {
        $this->instance->setOtherAmount($value);
        return $this;
    }

    /**
     * Sets tip amount field.
     *
     * @param Money|null $value
     */
    public function tipAmount(?Money $value): self
    {
        $this->instance->setTipAmount($value);
        return $this;
    }

    /**
     * Sets transaction status field.
     *
     * @param string|null $value
     */
    public function transactionStatus(?string $value): self
    {
        $this->instance->setTransactionStatus($value);
        return $this;
    }

    /**
     * Sets transaction subject field.
     *
     * @param string|null $value
     */
    public function transactionSubject(?string $value): self
    {
        $this->instance->setTransactionSubject($value);
        return $this;
    }

    /**
     * Sets transaction note field.
     *
     * @param string|null $value
     */
    public function transactionNote(?string $value): self
    {
        $this->instance->setTransactionNote($value);
        return $this;
    }

    /**
     * Sets payment tracking id field.
     *
     * @param string|null $value
     */
    public function paymentTrackingId(?string $value): self
    {
        $this->instance->setPaymentTrackingId($value);
        return $this;
    }

    /**
     * Sets bank reference id field.
     *
     * @param string|null $value
     */
    public function bankReferenceId(?string $value): self
    {
        $this->instance->setBankReferenceId($value);
        return $this;
    }

    /**
     * Sets ending balance field.
     *
     * @param Money|null $value
     */
    public function endingBalance(?Money $value): self
    {
        $this->instance->setEndingBalance($value);
        return $this;
    }

    /**
     * Sets available balance field.
     *
     * @param Money|null $value
     */
    public function availableBalance(?Money $value): self
    {
        $this->instance->setAvailableBalance($value);
        return $this;
    }

    /**
     * Sets invoice id field.
     *
     * @param string|null $value
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets custom field field.
     *
     * @param string|null $value
     */
    public function customField(?string $value): self
    {
        $this->instance->setCustomField($value);
        return $this;
    }

    /**
     * Sets protection eligibility field.
     *
     * @param string|null $value
     */
    public function protectionEligibility(?string $value): self
    {
        $this->instance->setProtectionEligibility($value);
        return $this;
    }

    /**
     * Sets credit term field.
     *
     * @param string|null $value
     */
    public function creditTerm(?string $value): self
    {
        $this->instance->setCreditTerm($value);
        return $this;
    }

    /**
     * Sets credit transactional fee field.
     *
     * @param Money|null $value
     */
    public function creditTransactionalFee(?Money $value): self
    {
        $this->instance->setCreditTransactionalFee($value);
        return $this;
    }

    /**
     * Sets credit promotional fee field.
     *
     * @param Money|null $value
     */
    public function creditPromotionalFee(?Money $value): self
    {
        $this->instance->setCreditPromotionalFee($value);
        return $this;
    }

    /**
     * Sets annual percentage rate field.
     *
     * @param string|null $value
     */
    public function annualPercentageRate(?string $value): self
    {
        $this->instance->setAnnualPercentageRate($value);
        return $this;
    }

    /**
     * Sets payment method type field.
     *
     * @param string|null $value
     */
    public function paymentMethodType(?string $value): self
    {
        $this->instance->setPaymentMethodType($value);
        return $this;
    }

    /**
     * Sets instrument type field.
     *
     * @param string|null $value
     */
    public function instrumentType(?string $value): self
    {
        $this->instance->setInstrumentType($value);
        return $this;
    }

    /**
     * Sets instrument sub type field.
     *
     * @param string|null $value
     */
    public function instrumentSubType(?string $value): self
    {
        $this->instance->setInstrumentSubType($value);
        return $this;
    }

    /**
     * Initializes a new Transaction Information object.
     */
    public function build(): TransactionInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
