<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VenmoWalletVaultAttributes;

/**
 * Builder for model VenmoWalletVaultAttributes
 *
 * @see VenmoWalletVaultAttributes
 */
class VenmoWalletVaultAttributesBuilder
{
    /**
     * @var VenmoWalletVaultAttributes
     */
    private $instance;

    private function __construct(VenmoWalletVaultAttributes $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Venmo Wallet Vault Attributes Builder object.
     *
     * @param string $storeInVault
     * @param string $usageType
     */
    public static function init(string $storeInVault, string $usageType): self
    {
        return new self(new VenmoWalletVaultAttributes($storeInVault, $usageType));
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets customer type field.
     *
     * @param string|null $value
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     *
     * @param bool|null $value
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Initializes a new Venmo Wallet Vault Attributes object.
     */
    public function build(): VenmoWalletVaultAttributes
    {
        return CoreHelper::clone($this->instance);
    }
}
