<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Merchant provided, buyer's native app preferences to app switch to the PayPal consumer app.
 */
class NativeAppContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $osType;

    /**
     * @var string|null
     */
    private $osVersion;

    /**
     * Returns Os Type.
     * Operating System type of the device that the buyer is using.
     */
    public function getOsType(): ?string
    {
        return $this->osType;
    }

    /**
     * Sets Os Type.
     * Operating System type of the device that the buyer is using.
     *
     * @maps os_type
     */
    public function setOsType(?string $osType): void
    {
        $this->osType = $osType;
    }

    /**
     * Returns Os Version.
     * Operating System version of the device that the buyer is using.
     */
    public function getOsVersion(): ?string
    {
        return $this->osVersion;
    }

    /**
     * Sets Os Version.
     * Operating System version of the device that the buyer is using.
     *
     * @maps os_version
     */
    public function setOsVersion(?string $osVersion): void
    {
        $this->osVersion = $osVersion;
    }

    /**
     * Converts the NativeAppContext object to a human-readable string representation.
     *
     * @return string The string representation of the NativeAppContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'NativeAppContext',
            ['osType' => $this->osType, 'osVersion' => $this->osVersion]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->osType)) {
            $json['os_type']    = $this->osType;
        }
        if (isset($this->osVersion)) {
            $json['os_version'] = $this->osVersion;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
