<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Completes an capture payment for an order.
 */
class OrderCaptureRequest implements \JsonSerializable
{
    /**
     * @var OrderCaptureRequestPaymentSource|null
     */
    private $paymentSource;

    /**
     * Returns Payment Source.
     * The payment source definition.
     */
    public function getPaymentSource(): ?OrderCaptureRequestPaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment source definition.
     *
     * @maps payment_source
     */
    public function setPaymentSource(?OrderCaptureRequestPaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Converts the OrderCaptureRequest object to a human-readable string representation.
     *
     * @return string The string representation of the OrderCaptureRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('OrderCaptureRequest', ['paymentSource' => $this->paymentSource]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->paymentSource)) {
            $json['payment_source'] = $this->paymentSource;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
