<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The pricing tier details.
 */
class PricingTier implements \JsonSerializable
{
    /**
     * @var string
     */
    private $startingQuantity;

    /**
     * @var string|null
     */
    private $endingQuantity;

    /**
     * @var Money
     */
    private $amount;

    /**
     * @param string $startingQuantity
     * @param Money $amount
     */
    public function __construct(string $startingQuantity, Money $amount)
    {
        $this->startingQuantity = $startingQuantity;
        $this->amount = $amount;
    }

    /**
     * Returns Starting Quantity.
     * The starting quantity for the tier.
     */
    public function getStartingQuantity(): string
    {
        return $this->startingQuantity;
    }

    /**
     * Sets Starting Quantity.
     * The starting quantity for the tier.
     *
     * @required
     * @maps starting_quantity
     */
    public function setStartingQuantity(string $startingQuantity): void
    {
        $this->startingQuantity = $startingQuantity;
    }

    /**
     * Returns Ending Quantity.
     * The ending quantity for the tier. Optional for the last tier.
     */
    public function getEndingQuantity(): ?string
    {
        return $this->endingQuantity;
    }

    /**
     * Sets Ending Quantity.
     * The ending quantity for the tier. Optional for the last tier.
     *
     * @maps ending_quantity
     */
    public function setEndingQuantity(?string $endingQuantity): void
    {
        $this->endingQuantity = $endingQuantity;
    }

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps amount
     */
    public function setAmount(Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Converts the PricingTier object to a human-readable string representation.
     *
     * @return string The string representation of the PricingTier object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PricingTier',
            [
                'startingQuantity' => $this->startingQuantity,
                'endingQuantity' => $this->endingQuantity,
                'amount' => $this->amount
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['starting_quantity']   = $this->startingQuantity;
        if (isset($this->endingQuantity)) {
            $json['ending_quantity'] = $this->endingQuantity;
        }
        $json['amount']              = $this->amount;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
