<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Reauthorizes an authorized PayPal account payment, by ID. To ensure that funds are still available,
 * reauthorize a payment after its initial three-day honor period expires. You can reauthorize a
 * payment only once from days four to 29. If 30 days have transpired since the date of the original
 * authorization, you must create an authorized payment instead of reauthorizing the original
 * authorized payment. A reauthorized payment itself has a new honor period of three days. You can
 * reauthorize an authorized payment once. The allowed amount depends on context and geography, for
 * example in US it is up to 115% of the original authorized amount, not to exceed an increase of $75
 * USD. Supports only the `amount` request parameter.
 */
class ReauthorizeRequest implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $amount;

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): ?Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps amount
     */
    public function setAmount(?Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Converts the ReauthorizeRequest object to a human-readable string representation.
     *
     * @return string The string representation of the ReauthorizeRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('ReauthorizeRequest', ['amount' => $this->amount]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->amount)) {
            $json['amount'] = $this->amount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
