<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The search response information.
 */
class SearchResponse implements \JsonSerializable
{
    /**
     * @var TransactionDetails[]|null
     */
    private $transactionDetails;

    /**
     * @var string|null
     */
    private $accountNumber;

    /**
     * @var string|null
     */
    private $startDate;

    /**
     * @var string|null
     */
    private $endDate;

    /**
     * @var string|null
     */
    private $lastRefreshedDatetime;

    /**
     * @var int|null
     */
    private $page;

    /**
     * @var int|null
     */
    private $totalItems;

    /**
     * @var int|null
     */
    private $totalPages;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Transaction Details.
     * An array of transaction detail objects.
     *
     * @return TransactionDetails[]|null
     */
    public function getTransactionDetails(): ?array
    {
        return $this->transactionDetails;
    }

    /**
     * Sets Transaction Details.
     * An array of transaction detail objects.
     *
     * @maps transaction_details
     *
     * @param TransactionDetails[]|null $transactionDetails
     */
    public function setTransactionDetails(?array $transactionDetails): void
    {
        $this->transactionDetails = $transactionDetails;
    }

    /**
     * Returns Account Number.
     * The merchant account number.
     */
    public function getAccountNumber(): ?string
    {
        return $this->accountNumber;
    }

    /**
     * Sets Account Number.
     * The merchant account number.
     *
     * @maps account_number
     */
    public function setAccountNumber(?string $accountNumber): void
    {
        $this->accountNumber = $accountNumber;
    }

    /**
     * Returns Start Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getStartDate(): ?string
    {
        return $this->startDate;
    }

    /**
     * Sets Start Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps start_date
     */
    public function setStartDate(?string $startDate): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns End Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getEndDate(): ?string
    {
        return $this->endDate;
    }

    /**
     * Sets End Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps end_date
     */
    public function setEndDate(?string $endDate): void
    {
        $this->endDate = $endDate;
    }

    /**
     * Returns Last Refreshed Datetime.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getLastRefreshedDatetime(): ?string
    {
        return $this->lastRefreshedDatetime;
    }

    /**
     * Sets Last Refreshed Datetime.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps last_refreshed_datetime
     */
    public function setLastRefreshedDatetime(?string $lastRefreshedDatetime): void
    {
        $this->lastRefreshedDatetime = $lastRefreshedDatetime;
    }

    /**
     * Returns Page.
     * A zero-relative index of transactions.
     */
    public function getPage(): ?int
    {
        return $this->page;
    }

    /**
     * Sets Page.
     * A zero-relative index of transactions.
     *
     * @maps page
     */
    public function setPage(?int $page): void
    {
        $this->page = $page;
    }

    /**
     * Returns Total Items.
     * The total number of transactions as an integer beginning with the specified `page` in the full
     * result and not just in this response.
     */
    public function getTotalItems(): ?int
    {
        return $this->totalItems;
    }

    /**
     * Sets Total Items.
     * The total number of transactions as an integer beginning with the specified `page` in the full
     * result and not just in this response.
     *
     * @maps total_items
     */
    public function setTotalItems(?int $totalItems): void
    {
        $this->totalItems = $totalItems;
    }

    /**
     * Returns Total Pages.
     * The total number of pages, as an `integer`, when the `total_items` is divided into pages of the
     * specified `page_size`.
     */
    public function getTotalPages(): ?int
    {
        return $this->totalPages;
    }

    /**
     * Sets Total Pages.
     * The total number of pages, as an `integer`, when the `total_items` is divided into pages of the
     * specified `page_size`.
     *
     * @maps total_pages
     */
    public function setTotalPages(?int $totalPages): void
    {
        $this->totalPages = $totalPages;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the SearchResponse object to a human-readable string representation.
     *
     * @return string The string representation of the SearchResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SearchResponse',
            [
                'transactionDetails' => $this->transactionDetails,
                'accountNumber' => $this->accountNumber,
                'startDate' => $this->startDate,
                'endDate' => $this->endDate,
                'lastRefreshedDatetime' => $this->lastRefreshedDatetime,
                'page' => $this->page,
                'totalItems' => $this->totalItems,
                'totalPages' => $this->totalPages,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->transactionDetails)) {
            $json['transaction_details']     = $this->transactionDetails;
        }
        if (isset($this->accountNumber)) {
            $json['account_number']          = $this->accountNumber;
        }
        if (isset($this->startDate)) {
            $json['start_date']              = $this->startDate;
        }
        if (isset($this->endDate)) {
            $json['end_date']                = $this->endDate;
        }
        if (isset($this->lastRefreshedDatetime)) {
            $json['last_refreshed_datetime'] = $this->lastRefreshedDatetime;
        }
        if (isset($this->page)) {
            $json['page']                    = $this->page;
        }
        if (isset($this->totalItems)) {
            $json['total_items']             = $this->totalItems;
        }
        if (isset($this->totalPages)) {
            $json['total_pages']             = $this->totalPages;
        }
        if (isset($this->links)) {
            $json['links']                   = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
