<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The application context, which customizes the payer experience during the subscription approval
 * process with PayPal.
 */
class SubscriptionApplicationContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $brandName;

    /**
     * @var string|null
     */
    private $locale;

    /**
     * @var string|null
     */
    private $shippingPreference = ExperienceContextShippingPreference::GET_FROM_FILE;

    /**
     * @var string|null
     */
    private $userAction = ApplicationContextUserAction::SUBSCRIBE_NOW;

    /**
     * @var PaymentMethod|null
     */
    private $paymentMethod;

    /**
     * @var string
     */
    private $returnUrl;

    /**
     * @var string
     */
    private $cancelUrl;

    /**
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public function __construct(string $returnUrl, string $cancelUrl)
    {
        $this->returnUrl = $returnUrl;
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Returns Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site.
     */
    public function getBrandName(): ?string
    {
        return $this->brandName;
    }

    /**
     * Sets Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site.
     *
     * @maps brand_name
     */
    public function setBrandName(?string $brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * Returns Locale.
     * The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal supports a
     * five-character code. For example, `da-DK`, `he-IL`, `id-ID`, `ja-JP`, `no-NO`, `pt-BR`, `ru-RU`, `sv-
     * SE`, `th-TH`, `zh-CN`, `zh-HK`, or `zh-TW`.
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Sets Locale.
     * The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal supports a
     * five-character code. For example, `da-DK`, `he-IL`, `id-ID`, `ja-JP`, `no-NO`, `pt-BR`, `ru-RU`, `sv-
     * SE`, `th-TH`, `zh-CN`, `zh-HK`, or `zh-TW`.
     *
     * @maps locale
     */
    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * Returns Shipping Preference.
     * The location from which the shipping address is derived.
     */
    public function getShippingPreference(): ?string
    {
        return $this->shippingPreference;
    }

    /**
     * Sets Shipping Preference.
     * The location from which the shipping address is derived.
     *
     * @maps shipping_preference
     */
    public function setShippingPreference(?string $shippingPreference): void
    {
        $this->shippingPreference = $shippingPreference;
    }

    /**
     * Returns User Action.
     * Configures the label name to `Continue` or `Subscribe Now` for subscription consent experience.
     */
    public function getUserAction(): ?string
    {
        return $this->userAction;
    }

    /**
     * Sets User Action.
     * Configures the label name to `Continue` or `Subscribe Now` for subscription consent experience.
     *
     * @maps user_action
     */
    public function setUserAction(?string $userAction): void
    {
        $this->userAction = $userAction;
    }

    /**
     * Returns Payment Method.
     * The customer and merchant payment preferences.
     */
    public function getPaymentMethod(): ?PaymentMethod
    {
        return $this->paymentMethod;
    }

    /**
     * Sets Payment Method.
     * The customer and merchant payment preferences.
     *
     * @maps payment_method
     */
    public function setPaymentMethod(?PaymentMethod $paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Returns Return Url.
     * The URL where the customer is redirected after the customer approves the payment.
     */
    public function getReturnUrl(): string
    {
        return $this->returnUrl;
    }

    /**
     * Sets Return Url.
     * The URL where the customer is redirected after the customer approves the payment.
     *
     * @required
     * @maps return_url
     */
    public function setReturnUrl(string $returnUrl): void
    {
        $this->returnUrl = $returnUrl;
    }

    /**
     * Returns Cancel Url.
     * The URL where the customer is redirected after the customer cancels the payment.
     */
    public function getCancelUrl(): string
    {
        return $this->cancelUrl;
    }

    /**
     * Sets Cancel Url.
     * The URL where the customer is redirected after the customer cancels the payment.
     *
     * @required
     * @maps cancel_url
     */
    public function setCancelUrl(string $cancelUrl): void
    {
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Converts the SubscriptionApplicationContext object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionApplicationContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionApplicationContext',
            [
                'brandName' => $this->brandName,
                'locale' => $this->locale,
                'shippingPreference' => $this->shippingPreference,
                'userAction' => $this->userAction,
                'paymentMethod' => $this->paymentMethod,
                'returnUrl' => $this->returnUrl,
                'cancelUrl' => $this->cancelUrl
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->brandName)) {
            $json['brand_name']          = $this->brandName;
        }
        if (isset($this->locale)) {
            $json['locale']              = $this->locale;
        }
        if (isset($this->shippingPreference)) {
            $json['shipping_preference'] = $this->shippingPreference;
        }
        if (isset($this->userAction)) {
            $json['user_action']         = $this->userAction;
        }
        if (isset($this->paymentMethod)) {
            $json['payment_method']      = $this->paymentMethod;
        }
        $json['return_url']              = $this->returnUrl;
        $json['cancel_url']              = $this->cancelUrl;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
