<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The payment source definition. To be eligible to create subscription using debit or credit card, you
 * will need to sign up here (https://www.paypal.com/bizsignup/entry/product/ppcp). Please note, its
 * available only for non-3DS cards and for merchants in US and AU regions.
 */
class SubscriptionPaymentSource implements \JsonSerializable
{
    /**
     * @var SubscriptionCardRequest|null
     */
    private $card;

    /**
     * Returns Card.
     * The payment card to use to fund a payment. Can be a credit or debit card.
     */
    public function getCard(): ?SubscriptionCardRequest
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * The payment card to use to fund a payment. Can be a credit or debit card.
     *
     * @maps card
     */
    public function setCard(?SubscriptionCardRequest $card): void
    {
        $this->card = $card;
    }

    /**
     * Converts the SubscriptionPaymentSource object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionPaymentSource object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('SubscriptionPaymentSource', ['card' => $this->card]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card'] = $this->card;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
