<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The transaction details.
 */
class TransactionDetails implements \JsonSerializable
{
    /**
     * @var TransactionInformation|null
     */
    private $transactionInfo;

    /**
     * @var PayerInformation|null
     */
    private $payerInfo;

    /**
     * @var ShippingInformation|null
     */
    private $shippingInfo;

    /**
     * @var CartInformation|null
     */
    private $cartInfo;

    /**
     * @var StoreInformation|null
     */
    private $storeInfo;

    /**
     * @var AuctionInformation|null
     */
    private $auctionInfo;

    /**
     * @var IncentiveInformation|null
     */
    private $incentiveInfo;

    /**
     * Returns Transaction Info.
     * The transaction information.
     */
    public function getTransactionInfo(): ?TransactionInformation
    {
        return $this->transactionInfo;
    }

    /**
     * Sets Transaction Info.
     * The transaction information.
     *
     * @maps transaction_info
     */
    public function setTransactionInfo(?TransactionInformation $transactionInfo): void
    {
        $this->transactionInfo = $transactionInfo;
    }

    /**
     * Returns Payer Info.
     * The payer information.
     */
    public function getPayerInfo(): ?PayerInformation
    {
        return $this->payerInfo;
    }

    /**
     * Sets Payer Info.
     * The payer information.
     *
     * @maps payer_info
     */
    public function setPayerInfo(?PayerInformation $payerInfo): void
    {
        $this->payerInfo = $payerInfo;
    }

    /**
     * Returns Shipping Info.
     * The shipping information.
     */
    public function getShippingInfo(): ?ShippingInformation
    {
        return $this->shippingInfo;
    }

    /**
     * Sets Shipping Info.
     * The shipping information.
     *
     * @maps shipping_info
     */
    public function setShippingInfo(?ShippingInformation $shippingInfo): void
    {
        $this->shippingInfo = $shippingInfo;
    }

    /**
     * Returns Cart Info.
     * The cart information.
     */
    public function getCartInfo(): ?CartInformation
    {
        return $this->cartInfo;
    }

    /**
     * Sets Cart Info.
     * The cart information.
     *
     * @maps cart_info
     */
    public function setCartInfo(?CartInformation $cartInfo): void
    {
        $this->cartInfo = $cartInfo;
    }

    /**
     * Returns Store Info.
     * The store information.
     */
    public function getStoreInfo(): ?StoreInformation
    {
        return $this->storeInfo;
    }

    /**
     * Sets Store Info.
     * The store information.
     *
     * @maps store_info
     */
    public function setStoreInfo(?StoreInformation $storeInfo): void
    {
        $this->storeInfo = $storeInfo;
    }

    /**
     * Returns Auction Info.
     * The auction information.
     */
    public function getAuctionInfo(): ?AuctionInformation
    {
        return $this->auctionInfo;
    }

    /**
     * Sets Auction Info.
     * The auction information.
     *
     * @maps auction_info
     */
    public function setAuctionInfo(?AuctionInformation $auctionInfo): void
    {
        $this->auctionInfo = $auctionInfo;
    }

    /**
     * Returns Incentive Info.
     * The incentive details.
     */
    public function getIncentiveInfo(): ?IncentiveInformation
    {
        return $this->incentiveInfo;
    }

    /**
     * Sets Incentive Info.
     * The incentive details.
     *
     * @maps incentive_info
     */
    public function setIncentiveInfo(?IncentiveInformation $incentiveInfo): void
    {
        $this->incentiveInfo = $incentiveInfo;
    }

    /**
     * Converts the TransactionDetails object to a human-readable string representation.
     *
     * @return string The string representation of the TransactionDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'TransactionDetails',
            [
                'transactionInfo' => $this->transactionInfo,
                'payerInfo' => $this->payerInfo,
                'shippingInfo' => $this->shippingInfo,
                'cartInfo' => $this->cartInfo,
                'storeInfo' => $this->storeInfo,
                'auctionInfo' => $this->auctionInfo,
                'incentiveInfo' => $this->incentiveInfo
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->transactionInfo)) {
            $json['transaction_info'] = $this->transactionInfo;
        }
        if (isset($this->payerInfo)) {
            $json['payer_info']       = $this->payerInfo;
        }
        if (isset($this->shippingInfo)) {
            $json['shipping_info']    = $this->shippingInfo;
        }
        if (isset($this->cartInfo)) {
            $json['cart_info']        = $this->cartInfo;
        }
        if (isset($this->storeInfo)) {
            $json['store_info']       = $this->storeInfo;
        }
        if (isset($this->auctionInfo)) {
            $json['auction_info']     = $this->auctionInfo;
        }
        if (isset($this->incentiveInfo)) {
            $json['incentive_info']   = $this->incentiveInfo;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
