<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The update pricing scheme request details.
 */
class UpdatePricingScheme implements \JsonSerializable
{
    /**
     * @var int
     */
    private $billingCycleSequence;

    /**
     * @var SubscriptionPricingScheme
     */
    private $pricingScheme;

    /**
     * @param int $billingCycleSequence
     * @param SubscriptionPricingScheme $pricingScheme
     */
    public function __construct(int $billingCycleSequence, SubscriptionPricingScheme $pricingScheme)
    {
        $this->billingCycleSequence = $billingCycleSequence;
        $this->pricingScheme = $pricingScheme;
    }

    /**
     * Returns Billing Cycle Sequence.
     * The billing cycle sequence.
     */
    public function getBillingCycleSequence(): int
    {
        return $this->billingCycleSequence;
    }

    /**
     * Sets Billing Cycle Sequence.
     * The billing cycle sequence.
     *
     * @required
     * @maps billing_cycle_sequence
     */
    public function setBillingCycleSequence(int $billingCycleSequence): void
    {
        $this->billingCycleSequence = $billingCycleSequence;
    }

    /**
     * Returns Pricing Scheme.
     * The pricing scheme details.
     */
    public function getPricingScheme(): SubscriptionPricingScheme
    {
        return $this->pricingScheme;
    }

    /**
     * Sets Pricing Scheme.
     * The pricing scheme details.
     *
     * @required
     * @maps pricing_scheme
     */
    public function setPricingScheme(SubscriptionPricingScheme $pricingScheme): void
    {
        $this->pricingScheme = $pricingScheme;
    }

    /**
     * Converts the UpdatePricingScheme object to a human-readable string representation.
     *
     * @return string The string representation of the UpdatePricingScheme object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'UpdatePricingScheme',
            ['billingCycleSequence' => $this->billingCycleSequence, 'pricingScheme' => $this->pricingScheme]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['billing_cycle_sequence'] = $this->billingCycleSequence;
        $json['pricing_scheme']         = $this->pricingScheme;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
