<?php
require_once 'config/database.php';
require_once 'config/auth.php';
require_once 'includes/functions.php';

$message = '';
$messageType = 'error';

$token = $_GET['token'] ?? '';

if (!empty($token)) {
    if (verifyEmail($token)) {
        $message = 'Email verified successfully! You can now log in to your account.';
        $messageType = 'success';
    } else {
        $message = 'Invalid or expired verification token.';
    }
} else {
    $message = 'No verification token provided.';
}

$page_title = 'Email Verification - Mutalex Academy';
include 'includes/header.php';
?>

<section class="login-section">
    <div class="container">
        <div class="login-card">
            <div class="login-header">
                <h1>Email Verification</h1>
            </div>

            <div class="alert alert-<?php echo $messageType; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>

            <div class="login-help">
                <p><a href="login.php">Go to Login</a></p>
                <?php if ($messageType === 'success'): ?>
                    <p><a href="login.php?verified=1">Login Now</a></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>