# Firebase Setup for Calendar Live Mode

This guide will help you set up Firebase to enable live mode for the calendar functionality.

## Prerequisites

1. A Google account
2. Node.js and npm (for Firebase CLI, optional but recommended)

## Step 1: Create a Firebase Project

1. Go to [Firebase Console](https://console.firebase.google.com/)
2. Click "Create a project" or select an existing project
3. Enter your project name (e.g., "lms-calendar")
4. Follow the setup wizard to create the project

## Step 2: Enable Firestore Database

1. In your Firebase project, go to "Firestore Database"
2. Click "Create database"
3. Choose "Start in test mode" (you can change security rules later)
4. Select a location for your database (choose the one closest to your users)

## Step 3: Add a Web App

1. In your Firebase project, click the gear icon → "Project settings"
2. Scroll down to "Your apps" section
3. Click the "</>" icon to add a web app
4. Enter an app nickname (e.g., "LMS Calendar")
5. **Important**: Check "Also set up Firebase Hosting" if you plan to host the app
6. Click "Register app"

## Step 4: Get Firebase Configuration

After registering the web app, you'll see a code snippet with your config. Copy these values:

```javascript
const firebaseConfig = {
  apiKey: "AIzaSyC...",
  authDomain: "your-project.firebaseapp.com",
  projectId: "your-project-id",
  storageBucket: "your-project.appspot.com",
  messagingSenderId: "123456789012",
  appId: "1:123456789012:web:abcdef123456789",
  measurementId: "G-ABCDEFGHIJ" // Optional
};
```

## Step 5: Configure Environment Variables

1. Open the `.env` file in your project root
2. Replace the placeholder values with your actual Firebase config:

```env
FIREBASE_API_KEY=AIzaSyC_your_actual_api_key_here
FIREBASE_AUTH_DOMAIN=your-project.firebaseapp.com
FIREBASE_PROJECT_ID=your-project-id
FIREBASE_STORAGE_BUCKET=your-project.appspot.com
FIREBASE_MESSAGING_SENDER_ID=123456789012
FIREBASE_APP_ID=1:123456789012:web:abcdef123456789
FIREBASE_MEASUREMENT_ID=G-ABCDEFGHIJ
CALENDAR_APP_ID=lms-calendar-app
```

## Step 6: Set Up Firestore Security Rules (Optional but Recommended)

For production use, update your Firestore security rules:

1. Go to Firestore Database → Rules
2. Replace the default rules with something like:

```javascript
rules_version = '2';
service cloud.firestore {
  match /databases/{database}/documents {
    // Allow read/write access to calendar events for authenticated users
    match /artifacts/{appId}/public/data/events/{eventId} {
      allow read, write: if request.auth != null;
    }

    // Allow admin users full access
    match /{document=**} {
      allow read, write: if request.auth != null &&
        request.auth.token.admin == true;
    }
  }
}
```

## Step 7: Test the Calendar

1. Access the calendar from the student dashboard or admin panel
2. Try adding an event - it should now save to Firebase and sync across all users
3. Events should persist between sessions

## Troubleshooting

### Calendar still shows "Mock mode"
- Check that your `.env` file has the correct Firebase values
- Make sure the web server has been restarted to load new environment variables
- Check browser console for Firebase errors

### Firebase errors in console
- Verify all Firebase config values are correct
- Ensure Firestore is enabled in your Firebase project
- Check that your domain is added to authorized domains in Firebase Authentication

### Events not saving
- Check Firestore security rules
- Ensure users are authenticated
- Verify the collection path matches: `/artifacts/{appId}/public/data/events`

## Additional Firebase Features (Optional)

### Enable Authentication
If you want user-specific events or admin-only editing:

1. Go to Authentication in Firebase Console
2. Enable sign-in methods (Email/Password, Google, etc.)
3. Update the calendar code to handle user authentication

### Enable Analytics
If you included `measurementId`, Firebase Analytics will automatically track usage.

## Support

If you encounter issues:
1. Check the browser console for detailed error messages
2. Verify all Firebase config values
3. Ensure Firestore database exists and is accessible
4. Check Firebase Console for any billing or quota issues