<?php
require_once '../config/database.php';
require_once '../config/auth.php';
require_once '../config/rbac.php';
require_once '../includes/functions.php';
require_once '../includes/middleware.php';

// Check if user is admin
adminOnly();

$user = getUserContext();
$page_title = 'Analytics Dashboard';

include 'includes/admin_header.php';
?>

    <!-- Analytics Hero Section -->
    <section class="analytics-hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Analytics Dashboard</h1>
                    <p class="hero-subtitle">Track your course performance, student engagement, and revenue insights</p>
                    <div class="hero-meta">
                        <div class="meta-item">
                            <i class="fas fa-clock"></i>
                            <span>Last updated: Oct 24, 2023 at 9:45 AM</span>
                        </div>
                        <div class="meta-item">
                            <i class="fas fa-calendar"></i>
                            <span>Data from last 12 months</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-chart-placeholder">
                        <i class="fas fa-chart-line"></i>
                        <div class="chart-bars">
                            <div class="bar" style="height: 60%; animation-delay: 0.1s"></div>
                            <div class="bar" style="height: 80%; animation-delay: 0.2s"></div>
                            <div class="bar" style="height: 40%; animation-delay: 0.3s"></div>
                            <div class="bar" style="height: 90%; animation-delay: 0.4s"></div>
                            <div class="bar" style="height: 70%; animation-delay: 0.5s"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Key Metrics Section -->
    <section class="metrics-section">
        <div class="container">
            <div class="metrics-grid">
                <div class="metric-card primary">
                    <div class="metric-header">
                        <div class="metric-icon">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div class="metric-badge">
                            <i class="fas fa-arrow-up"></i>
                            +124
                        </div>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">1,458</div>
                        <div class="metric-label">Total Students</div>
                        <div class="metric-description">Students enrolled in your courses</div>
                    </div>
                </div>

                <div class="metric-card success">
                    <div class="metric-header">
                        <div class="metric-icon">
                            <i class="fas fa-book-open"></i>
                        </div>
                        <div class="metric-badge">
                            <i class="fas fa-chart-line"></i>
                            85%
                        </div>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">12</div>
                        <div class="metric-label">Active Courses</div>
                        <div class="metric-description">Courses you're currently teaching</div>
                    </div>
                </div>

                <div class="metric-card warning">
                    <div class="metric-header">
                        <div class="metric-icon">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                        <div class="metric-badge">
                            <i class="fas fa-trending-up"></i>
                            Revenue
                        </div>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">$15,420.50</div>
                        <div class="metric-label">Total Revenue</div>
                        <div class="metric-description">Earnings from course sales</div>
                    </div>
                </div>

                <div class="metric-card info">
                    <div class="metric-header">
                        <div class="metric-icon">
                            <i class="fas fa-chart-pie"></i>
                        </div>
                        <div class="metric-badge">
                            <i class="fas fa-users"></i>
                            342
                        </div>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">68%</div>
                        <div class="metric-label">Avg. Progress</div>
                        <div class="metric-description">Student completion progress</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Charts and Insights Section -->
    <section class="charts-section">
        <div class="container">
            <div class="charts-grid">

                <!-- Course Performance Chart -->
                <div class="chart-card">
                    <div class="card-header">
                        <div class="card-title">
                            <i class="fas fa-chart-bar"></i>
                            <h3>Course Performance</h3>
                        </div>
                        <div class="card-controls">
                            <select class="metric-selector" id="performanceMetric">
                                <option value="enrollments">Enrollments</option>
                                <option value="revenue">Revenue</option>
                            </select>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="performanceChart"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Top Performing Courses -->
                <div class="insights-card">
                    <div class="card-header">
                        <div class="card-title">
                            <i class="fas fa-trophy"></i>
                            <h3>Top Courses</h3>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="top-courses-list">
                            <!-- Mock Item 1 -->
                            <div class="course-ranking-item">
                                <div class="ranking-badge">
                                    <span class="rank-number">1</span>
                                </div>
                                <div class="course-details">
                                    <h4>Advanced Web Development</h4>
                                    <div class="course-metrics">
                                        <div class="metric">
                                            <i class="fas fa-users"></i>
                                            <span>450 students</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-check-circle"></i>
                                            <span>92% completion</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-star" style="color: #f59e0b;"></i>
                                            <span>4.8</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Mock Item 2 -->
                            <div class="course-ranking-item">
                                <div class="ranking-badge">
                                    <span class="rank-number">2</span>
                                </div>
                                <div class="course-details">
                                    <h4>UI/UX Design Principles</h4>
                                    <div class="course-metrics">
                                        <div class="metric">
                                            <i class="fas fa-users"></i>
                                            <span>320 students</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-check-circle"></i>
                                            <span>88% completion</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-star" style="color: #f59e0b;"></i>
                                            <span>4.9</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Mock Item 3 -->
                            <div class="course-ranking-item">
                                <div class="ranking-badge">
                                    <span class="rank-number">3</span>
                                </div>
                                <div class="course-details">
                                    <h4>Python for Data Science</h4>
                                    <div class="course-metrics">
                                        <div class="metric">
                                            <i class="fas fa-users"></i>
                                            <span>280 students</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-check-circle"></i>
                                            <span>75% completion</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-star" style="color: #f59e0b;"></i>
                                            <span>4.7</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Mock Item 4 -->
                            <div class="course-ranking-item">
                                <div class="ranking-badge">
                                    <span class="rank-number">4</span>
                                </div>
                                <div class="course-details">
                                    <h4>React Native Mastery</h4>
                                    <div class="course-metrics">
                                        <div class="metric">
                                            <i class="fas fa-users"></i>
                                            <span>210 students</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-check-circle"></i>
                                            <span>60% completion</span>
                                        </div>
                                        <div class="metric">
                                            <i class="fas fa-star" style="color: #f59e0b;"></i>
                                            <span>4.6</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- Trends and Engagement Section -->
    <section class="trends-section">
        <div class="container">
            <div class="section-header">
                <h2>Trends & Engagement</h2>
                <p>Monitor enrollment patterns and student activity over time</p>
            </div>

            <div class="trends-grid">

                <!-- Enrollment Trends Chart -->
                <div class="trend-card">
                    <div class="card-header">
                        <div class="card-title">
                            <i class="fas fa-calendar-alt"></i>
                            <div>
                                <h3>Enrollment Trends</h3>
                                <p class="card-subtitle">Monthly enrollment data over the last 12 months</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="enrollmentChart"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Student Engagement Metrics -->
                <div class="engagement-card">
                    <div class="card-header">
                        <div class="card-title">
                            <i class="fas fa-users-cog"></i>
                            <div>
                                <h3>Student Engagement</h3>
                                <p class="card-subtitle">Key engagement metrics and completion rates</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="engagement-metrics">

                            <div class="metric-item">
                                <div class="metric-info">
                                    <div class="metric-label">Completion Rate</div>
                                    <div class="metric-value">78.5%</div>
                                </div>
                                <div class="metric-progress">
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: 78.5%"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="metric-item">
                                <div class="metric-info">
                                    <div class="metric-label">Average Progress</div>
                                    <div class="metric-value">62%</div>
                                </div>
                                <div class="metric-progress">
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: 62%"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="metric-item">
                                <div class="metric-info">
                                    <div class="metric-label">Avg. Completion Time</div>
                                    <div class="metric-value">14 days</div>
                                </div>
                                <div class="metric-visual">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>

                            <div class="metric-item">
                                <div class="metric-info">
                                    <div class="metric-label">Active This Week</div>
                                    <div class="metric-value">342 students</div>
                                </div>
                                <div class="metric-visual">
                                    <i class="fas fa-user-check"></i>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- Reviews Section -->
    <section class="reviews-section">
        <div class="container">
            <div class="section-header">
                <h2>Recent Student Reviews</h2>
                <p>What your students are saying about your courses</p>
                <button class="btn btn-outline-primary">
                    <i class="fas fa-eye"></i>
                    View All Reviews
                </button>
            </div>

            <div class="reviews-grid">
                <!-- Mock Review 1 -->
                <div class="review-card">
                    <div class="review-header">
                        <div class="reviewer-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="reviewer-info">
                            <h4>Sarah Johnson</h4>
                            <p class="course-name">Advanced Web Development</p>
                        </div>
                        <div class="review-rating">
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <span class="rating-number">5/5</span>
                        </div>
                    </div>
                    <div class="review-content">
                        <h5 class="review-title">Excellent course!</h5>
                        <p class="review-text">This course completely changed my perspective on frontend architecture. The instructor explains complex topics simply.</p>
                    </div>
                    <div class="review-footer">
                        <div class="review-date">
                            <i class="fas fa-calendar"></i>
                            Oct 22, 2023
                        </div>
                    </div>
                </div>

                <!-- Mock Review 2 -->
                <div class="review-card">
                    <div class="review-header">
                        <div class="reviewer-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="reviewer-info">
                            <h4>Michael Chen</h4>
                            <p class="course-name">Python for Data Science</p>
                        </div>
                        <div class="review-rating">
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star"></i>
                            <span class="rating-number">4/5</span>
                        </div>
                    </div>
                    <div class="review-content">
                        <h5 class="review-title">Great content, pace is fast</h5>
                        <p class="review-text">The material is top notch, but beginners might find the pace a bit challenging. I learned a lot though!</p>
                    </div>
                    <div class="review-footer">
                        <div class="review-date">
                            <i class="fas fa-calendar"></i>
                            Oct 20, 2023
                        </div>
                    </div>
                </div>

                <!-- Mock Review 3 -->
                <div class="review-card">
                    <div class="review-header">
                        <div class="reviewer-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="reviewer-info">
                            <h4>Emily Davis</h4>
                            <p class="course-name">UI/UX Design Principles</p>
                        </div>
                        <div class="review-rating">
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <i class="fas fa-star filled"></i>
                            <span class="rating-number">5/5</span>
                        </div>
                    </div>
                    <div class="review-content">
                        <h5 class="review-title">Loved the projects</h5>
                        <p class="review-text">The hands-on projects were the best part. I have actual portfolio pieces now. Highly recommended!</p>
                    </div>
                    <div class="review-footer">
                        <div class="review-date">
                            <i class="fas fa-calendar"></i>
                            Oct 18, 2023
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Detailed Analytics Table Section -->
    <section class="analytics-table-section">
        <div class="container">
            <div class="section-header">
                <h2>Detailed Course Analytics</h2>
                <p>Comprehensive performance data for all your courses</p>
                <button class="btn btn-primary" onclick="alert('This is a static preview. Export functionality requires the backend.')">
                    <i class="fas fa-download"></i>
                    Export Data
                </button>
            </div>

            <div class="analytics-table-card">
                <div class="table-container">
                    <table class="analytics-table">
                        <thead>
                            <tr>
                                <th>Course</th>
                                <th>Enrollments</th>
                                <th>Completions</th>
                                <th>Avg. Progress</th>
                                <th>Rating</th>
                                <th>Revenue</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Mock Row 1 -->
                            <tr>
                                <td>
                                    <div class="course-cell">
                                        <div class="course-title">Advanced Web Development</div>
                                        <div class="course-meta">ID: 101</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">450</div>
                                        <div class="metric-label">students</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">414</div>
                                        <div class="metric-label">completed</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="progress-cell">
                                        <div class="progress-info">
                                            <span class="progress-value">92%</span>
                                            <div class="progress-bar">
                                                <div class="progress-fill" style="width: 92%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="rating-cell">
                                        <div class="rating-stars">
                                            <i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i>
                                        </div>
                                        <div class="rating-info">
                                            <span class="rating-number">4.8</span>
                                            <span class="rating-count">(120)</span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue-cell">
                                        <div class="revenue-amount">$4,500.00</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="actions-cell">
                                        <button class="btn btn-sm btn-outline-primary">Details</button>
                                    </div>
                                </td>
                            </tr>
                            <!-- Mock Row 2 -->
                            <tr>
                                <td>
                                    <div class="course-cell">
                                        <div class="course-title">UI/UX Design Principles</div>
                                        <div class="course-meta">ID: 102</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">320</div>
                                        <div class="metric-label">students</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">280</div>
                                        <div class="metric-label">completed</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="progress-cell">
                                        <div class="progress-info">
                                            <span class="progress-value">88%</span>
                                            <div class="progress-bar">
                                                <div class="progress-fill" style="width: 88%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="rating-cell">
                                        <div class="rating-stars">
                                            <i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i>
                                        </div>
                                        <div class="rating-info">
                                            <span class="rating-number">4.9</span>
                                            <span class="rating-count">(95)</span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue-cell">
                                        <div class="revenue-amount">$3,200.00</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="actions-cell">
                                        <button class="btn btn-sm btn-outline-primary">Details</button>
                                    </div>
                                </td>
                            </tr>
                            <!-- Mock Row 3 -->
                            <tr>
                                <td>
                                    <div class="course-cell">
                                        <div class="course-title">Python for Data Science</div>
                                        <div class="course-meta">ID: 103</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">280</div>
                                        <div class="metric-label">students</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="metric-cell">
                                        <div class="metric-value">210</div>
                                        <div class="metric-label">completed</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="progress-cell">
                                        <div class="progress-info">
                                            <span class="progress-value">75%</span>
                                            <div class="progress-bar">
                                                <div class="progress-fill" style="width: 75%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="rating-cell">
                                        <div class="rating-stars">
                                            <i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star filled"></i><i class="fas fa-star"></i>
                                        </div>
                                        <div class="rating-info">
                                            <span class="rating-number">4.7</span>
                                            <span class="rating-count">(82)</span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue-cell">
                                        <div class="revenue-amount">$2,800.00</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="actions-cell">
                                        <button class="btn btn-sm btn-outline-primary">Details</button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

<!-- Chart.js for visualizations -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- MOCK DATA FOR PREVIEW ---
    const courseLabels = ["Advanced Web Dev", "UI/UX Principles", "Python Data Science", "React Native", "Digital Marketing"];
    const enrollmentData = [450, 320, 280, 210, 150];
    const completionData = [414, 280, 210, 126, 90];
    const revenueData = [4500, 3200, 2800, 2100, 1500];

    const trendLabels = ["Nov", "Dec", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct"];
    const trendEnrollments = [45, 52, 60, 55, 68, 72, 85, 90, 88, 95, 110, 124];

    // 1. Performance Chart (Bar Chart)
    const perfCtx = document.getElementById('performanceChart').getContext('2d');

    const perfChart = new Chart(perfCtx, {
        type: 'bar',
        data: {
            labels: courseLabels,
            datasets: [
                {
                    label: 'Enrollments',
                    data: enrollmentData,
                    backgroundColor: '#667eea',
                    borderRadius: 4
                },
                {
                    label: 'Completions',
                    data: completionData,
                    backgroundColor: '#10b981',
                    borderRadius: 4
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { position: 'top' },
                tooltip: { mode: 'index', intersect: false }
            },
            scales: {
                y: { beginAtZero: true, grid: { borderDash: [2, 4] } },
                x: { grid: { display: false } }
            }
        }
    });

    // Handle Metric Selector Change
    document.getElementById('performanceMetric').addEventListener('change', function(e) {
        if(e.target.value === 'revenue') {
            perfChart.data.datasets = [{
                label: 'Revenue ($)',
                data: revenueData,
                backgroundColor: '#f59e0b',
                borderRadius: 4
            }];
        } else {
            perfChart.data.datasets = [
                {
                    label: 'Enrollments',
                    data: enrollmentData,
                    backgroundColor: '#667eea',
                    borderRadius: 4
                },
                {
                    label: 'Completions',
                    data: completionData,
                    backgroundColor: '#10b981',
                    borderRadius: 4
                }
            ];
        }
        perfChart.update();
    });

    // 2. Trends Chart (Line Chart)
    const trendsCtx = document.getElementById('enrollmentChart').getContext('2d');

    new Chart(trendsCtx, {
        type: 'line',
        data: {
            labels: trendLabels,
            datasets: [{
                label: 'Monthly Enrollments',
                data: trendEnrollments,
                borderColor: '#764ba2',
                backgroundColor: 'rgba(118, 75, 162, 0.1)',
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#fff',
                pointBorderColor: '#764ba2',
                pointBorderWidth: 2,
                pointRadius: 4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { display: false } },
            scales: {
                y: { beginAtZero: true, ticks: { precision: 0 } },
                x: { grid: { display: false } }
            }
        }
    });
});
</script>

<style>
/* Professional Analytics Dashboard Styles */
:root {
    --primary: #667eea;
    --primary-dark: #5a67d8;
    --secondary: #764ba2;
    --success: #10b981;
    --warning: #f59e0b;
    --info: #3b82f6;
    --dark: #1e293b;
    --light: #f8fafc;
    --gray: #64748b;
    --border: #e2e8f0;
}

body {
    background-color: #f1f5f9;
    color: var(--dark);
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    margin: 0;
    padding: 0;
}

/* Global Container */
.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1.5rem;
}

/* Button Helpers */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-weight: 500;
    cursor: pointer;
    text-decoration: none;
    transition: all 0.2s;
    border: none;
    font-size: 0.9rem;
}

.btn-primary {
    background-color: var(--primary);
    color: white;
}
.btn-primary:hover { background-color: var(--primary-dark); }

.btn-outline-primary {
    background-color: transparent;
    border: 1px solid var(--primary);
    color: var(--primary);
}
.btn-outline-primary:hover {
    background-color: var(--primary);
    color: white;
}

/* Hero Section */
.analytics-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 4rem 0 5rem; /* Extra padding for overlap */
    position: relative;
    overflow: hidden;
}

.analytics-hero::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
    background: radial-gradient(circle at 20% 50%, rgba(255,255,255,0.1) 0%, transparent 50%);
    opacity: 0.5;
}

.hero-content {
    position: relative;
    z-index: 2;
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 3rem;
    align-items: center;
}

.hero-text h1 {
    font-size: 2.5rem;
    font-weight: 800;
    margin: 0 0 1rem;
    line-height: 1.1;
}

.hero-subtitle {
    font-size: 1.1rem;
    opacity: 0.9;
    margin-bottom: 2rem;
    line-height: 1.6;
}

.hero-meta {
    display: flex;
    gap: 2rem;
    font-size: 0.9rem;
}

.hero-meta .meta-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    opacity: 0.8;
}

.hero-visual {
    display: flex;
    justify-content: center;
}

.hero-chart-placeholder {
    width: 200px;
    height: 150px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.hero-chart-placeholder i {
    font-size: 2rem;
    margin-bottom: 1rem;
    opacity: 0.8;
}

.chart-bars {
    display: flex;
    align-items: end;
    gap: 0.5rem;
    height: 60px;
}

.chart-bars .bar {
    width: 20px;
    background: rgba(255, 255, 255, 0.8);
    border-radius: 2px 2px 0 0;
    animation: growBar 1.5s ease-out forwards;
}

@keyframes growBar {
    from { height: 0; opacity: 0; }
    to { opacity: 1; }
}

/* Metrics Section */
.metrics-section {
    padding: 0 0 3rem;
    margin-top: -3rem; /* Negative margin to pull up */
    position: relative;
    z-index: 3;
}

.section-header {
    text-align: center;
    margin: 3rem 0;
}

.section-header h2 {
    font-size: 2rem;
    font-weight: 700;
    color: var(--dark);
    margin: 0 0 0.5rem;
}

.section-header p {
    font-size: 1.1rem;
    color: var(--gray);
    max-width: 600px;
    margin: 0 auto;
}

.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 1.5rem;
}

.metric-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    border: 1px solid var(--border);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    position: relative;
    overflow: hidden;
}

.metric-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}

.metric-card::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0;
    height: 4px;
}

.metric-card.primary::before { background: linear-gradient(90deg, #667eea, #764ba2); }
.metric-card.success::before { background: linear-gradient(90deg, #10b981, #059669); }
.metric-card.warning::before { background: linear-gradient(90deg, #f59e0b, #d97706); }
.metric-card.info::before { background: linear-gradient(90deg, #3b82f6, #2563eb); }

.metric-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1rem;
}

.metric-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.metric-card.primary .metric-icon { background: linear-gradient(135deg, #667eea, #764ba2); }
.metric-card.success .metric-icon { background: linear-gradient(135deg, #10b981, #059669); }
.metric-card.warning .metric-icon { background: linear-gradient(135deg, #f59e0b, #d97706); }
.metric-card.info .metric-icon { background: linear-gradient(135deg, #3b82f6, #2563eb); }

.metric-badge {
    background: #f1f5f9;
    color: var(--dark);
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.metric-value {
    font-size: 2rem;
    font-weight: 800;
    color: var(--dark);
    line-height: 1;
    margin-bottom: 0.25rem;
}

.metric-label {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--gray);
}

.metric-description {
    font-size: 0.8rem;
    color: #94a3b8;
    margin-top: 0.5rem;
}

/* Charts Section */
.charts-section, .trends-section, .reviews-section, .analytics-table-section {
    padding: 3rem 0;
    background: white;
}
.trends-section { background: #f8fafc; }

.charts-grid, .trends-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 2rem;
}

.chart-card, .insights-card, .trend-card, .engagement-card, .analytics-table-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
    border: 1px solid var(--border);
    display: flex;
    flex-direction: column;
    overflow: hidden;
}

.card-header {
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--border);
    display: flex;
    justify-content: space-between;
    align-items: center;
    background-color: #fff;
}

.card-title {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark);
}

.card-title i {
    color: var(--primary);
    font-size: 1.25rem;
}

.card-title h3 { margin: 0; font-size: 1.1rem; }
.card-subtitle { font-size: 0.85rem; color: var(--gray); margin: 0.2rem 0 0 0; font-weight: normal; }

.card-body { padding: 1.5rem; flex: 1; }

.chart-container {
    position: relative;
    height: 300px;
    width: 100%;
}

.metric-selector {
    padding: 0.25rem 0.5rem;
    border: 1px solid var(--border);
    border-radius: 6px;
    font-size: 0.85rem;
    color: var(--gray);
    outline: none;
    background: white;
}

/* Ranking List */
.top-courses-list { display: flex; flex-direction: column; gap: 0; }
.course-ranking-item {
    display: flex;
    gap: 1rem;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid #f1f5f9;
}
.course-ranking-item:last-child { border-bottom: none; padding-bottom: 0; }
.course-ranking-item:first-child { padding-top: 0; }

.ranking-badge {
    width: 32px;
    height: 32px;
    background: #f1f5f9;
    color: var(--primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    flex-shrink: 0;
}

.course-details { flex: 1; }
.course-details h4 { margin: 0 0 0.25rem 0; font-size: 0.95rem; color: var(--dark); }
.course-metrics { display: flex; gap: 1rem; font-size: 0.8rem; color: var(--gray); flex-wrap: wrap; }
.course-metrics .metric { display: flex; align-items: center; gap: 0.25rem; }

/* Engagement Metrics */
.engagement-metrics { display: flex; flex-direction: column; gap: 1.5rem; }

.metric-item { display: flex; flex-direction: column; gap: 0.5rem; }
.metric-info { display: flex; justify-content: space-between; align-items: flex-end; }
.metric-item .metric-visual { display: flex; justify-content: flex-end; color: var(--primary); opacity: 0.1; font-size: 1.5rem; margin-top: -1.5rem; pointer-events: none;}

.progress-bar {
    height: 8px;
    background: #f1f5f9;
    border-radius: 4px;
    overflow: hidden;
    width: 100%;
}
.progress-fill {
    height: 100%;
    background: var(--primary);
    border-radius: 4px;
}

/* Reviews Grid */
.reviews-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.review-card {
    background: white;
    border: 1px solid var(--border);
    border-radius: 12px;
    padding: 1.5rem;
    display: flex;
    flex-direction: column;
}

.review-header { display: flex; gap: 1rem; margin-bottom: 1rem; }
.reviewer-avatar {
    width: 40px; height: 40px;
    background: #f1f5f9;
    border-radius: 50%;
    display: flex; align-items: center; justify-content: center;
    color: var(--gray);
}
.reviewer-info h4 { margin: 0; font-size: 0.95rem; }
.course-name { margin: 0; font-size: 0.8rem; color: var(--gray); }
.review-rating { margin-left: auto; display: flex; align-items: center; gap: 0.1rem; font-size: 0.8rem; color: #fbbf24; }
.review-rating .filled { color: #f59e0b; }
.review-rating .rating-number { color: var(--gray); margin-left: 0.25rem; }

.review-content { flex: 1; margin-bottom: 1rem; }
.review-title { font-size: 1rem; font-weight: 600; margin: 0 0 0.5rem; }
.review-text { font-size: 0.9rem; color: var(--gray); line-height: 1.5; margin: 0; }

.review-footer { padding-top: 0.75rem; border-top: 1px dashed var(--border); display: flex; justify-content: space-between; font-size: 0.8rem; color: #94a3b8; }
.review-status.pending { color: var(--warning); display: flex; align-items: center; gap: 0.25rem; }

/* Table Styles */
.table-container { overflow-x: auto; -webkit-overflow-scrolling: touch; }
.analytics-table { width: 100%; border-collapse: collapse; min-width: 800px; }
.analytics-table th { text-align: left; padding: 1rem; font-size: 0.85rem; color: var(--gray); text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid var(--border); background: #f8fafc; font-weight: 600;}
.analytics-table td { padding: 1rem; vertical-align: middle; border-bottom: 1px solid #f1f5f9; }
.analytics-table tr:hover { background: #fcfcfc; }
.analytics-table tr:last-child td { border-bottom: none; }

.course-cell .course-title { font-weight: 600; font-size: 0.95rem; color: var(--dark); margin-bottom: 0.2rem;}
.course-cell .course-meta { font-size: 0.75rem; color: #94a3b8; }

.metric-cell { text-align: center; }
.metric-cell .metric-value { font-weight: 600; color: var(--dark); font-size: 0.95rem;}
.metric-cell .metric-label { font-size: 0.75rem; color: var(--gray); }

.progress-cell { width: 150px; }
.progress-info { display: flex; flex-direction: column; gap: 0.25rem; }
.progress-value { font-size: 0.8rem; font-weight: 600; }

.rating-stars { color: #f59e0b; font-size: 0.8rem; letter-spacing: -1px; }
.rating-info { font-size: 0.75rem; color: var(--gray); }

.revenue-amount { font-weight: 700; color: var(--success); }

.actions-cell .btn-sm { padding: 0.35rem 0.75rem; font-size: 0.8rem; }

/* Media Queries */
@media (max-width: 992px) {
    .hero-content { grid-template-columns: 1fr; text-align: center; gap: 2rem; }
    .hero-meta { justify-content: center; }
    .charts-grid, .trends-grid { grid-template-columns: 1fr; }
}
</style>

<?php include 'includes/admin_footer.php'; ?>