<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
</head>
<body class="admin-body">
    <div class="admin-wrapper">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <h2><i class="fas fa-cog"></i> Admin Panel</h2>
            </div>
            <nav class="sidebar-nav">
                <a href="dashboard.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
                <a href="analytics.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'analytics.php' ? 'active' : ''; ?>">
                    <i class="fas fa-chart-bar"></i>
                    Analytics
                </a>
                <a href="posts.php" class="nav-item <?php echo in_array(basename($_SERVER['PHP_SELF']), ['posts.php', 'add_post.php', 'edit_post.php']) ? 'active' : ''; ?>">
                    <i class="fas fa-file-alt"></i>
                    Posts
                </a>
                <a href="categories.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : ''; ?>">
                    <i class="fas fa-folder"></i>
                    Categories
                </a>
                <a href="course_categories.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'course_categories.php' ? 'active' : ''; ?>">
                    <i class="fas fa-tags"></i>
                    Course Categories
                </a>
                <a href="course_pricing.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'course_pricing.php' ? 'active' : ''; ?>">
                    <i class="fas fa-dollar-sign"></i>
                    Course Pricing
                </a>
                <a href="payment_gateways.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'payment_gateways.php' ? 'active' : ''; ?>">
                    <i class="fas fa-credit-card"></i>
                    Payment Settings
                </a>
                <a href="/blogg/survey/" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'surveys.php' ? 'active' : ''; ?>">
                    <i class="fas fa-poll"></i>
                    Surveys
                </a>
                <a href="announcements.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'announcements.php' ? 'active' : ''; ?>">
                    <i class="fas fa-bullhorn"></i>
                    Announcements
                </a>
                <a href="calendar.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'calendar.php' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar"></i>
                    Calendar Events
                </a>
                <a href="users.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i>
                    User Management
                </a>
                <a href="roles.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'roles.php' ? 'active' : ''; ?>">
                    <i class="fas fa-shield-alt"></i>
                    Roles Management
                </a>
                <a href="account.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'account.php' ? 'active' : ''; ?>">
                    <i class="fas fa-user-cog"></i>
                    Account
                </a>
                <a href="site_settings.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'site_settings.php' ? 'active' : ''; ?>">
                    <i class="fas fa-cogs"></i>
                    Site Settings
                </a>
                <a href="logs.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'logs.php' ? 'active' : ''; ?>">
                    <i class="fas fa-history"></i>
                    System Audit Logs
                </a>
                <a href="../home.php" class="nav-item" target="_blank">
                    <i class="fas fa-eye"></i>
                    View Site
                </a>
                <a href="../logout.php" class="nav-item">
                    <i class="fas fa-sign-out-alt"></i>
                    Logout
                </a>
            </nav>
        </aside>

        <main class="admin-main">
            <header class="admin-header">
                <h1><?php echo isset($page_title) ? $page_title : 'Admin Panel'; ?></h1>
                <div class="admin-user">
                    <span>Welcome, <?php echo htmlspecialchars($_SESSION['username'] ?? 'User'); ?></span>
                </div>
            </header>

            <div class="admin-content">