<?php
/*
Firebase configuration for calendar functionality

To enable Firebase integration, set the following environment variables:
- FIREBASE_API_KEY
- FIREBASE_AUTH_DOMAIN
- FIREBASE_PROJECT_ID
- FIREBASE_STORAGE_BUCKET
- FIREBASE_MESSAGING_SENDER_ID
- FIREBASE_APP_ID
- FIREBASE_MEASUREMENT_ID (optional)
- CALENDAR_APP_ID (optional, defaults to 'lms-calendar-app')
- FIREBASE_AUTH_TOKEN (optional, for custom authentication)

If Firebase is not configured, the calendar will run in mock mode with sample data.

To get these values:
1. Go to Firebase Console (https://console.firebase.google.com/)
2. Create a new project or select existing one
3. Go to Project Settings > General > Your apps
4. Add a web app or use existing one
5. Copy the config values from the SDK setup
*/

$firebaseConfig = [
    'apiKey' => getenv('FIREBASE_API_KEY') ?: 'AIzaSyDUMMY_API_KEY_FOR_DEVELOPMENT',
    'authDomain' => getenv('FIREBASE_AUTH_DOMAIN') ?: 'lms-calendar.firebaseapp.com',
    'projectId' => getenv('FIREBASE_PROJECT_ID') ?: 'lms-calendar',
    'storageBucket' => getenv('FIREBASE_STORAGE_BUCKET') ?: 'lms-calendar.appspot.com',
    'messagingSenderId' => getenv('FIREBASE_MESSAGING_SENDER_ID') ?: '123456789012',
    'appId' => getenv('FIREBASE_APP_ID') ?: '1:123456789012:web:abcdef123456789',
    'measurementId' => getenv('FIREBASE_MEASUREMENT_ID') ?: 'G-ABCDEFGHIJ'
];

// App ID for calendar
$appId = getenv('CALENDAR_APP_ID') ?: 'lms-calendar-app';

// Initial auth token (if using custom auth)
$initialAuthToken = getenv('FIREBASE_AUTH_TOKEN') ?: null;