<?php
// Common mobile menu for instructor panel
?>
<!-- Mobile Navigation Overlay (Hidden by default) -->
<div id="mobileMenu" class="fixed inset-0 bg-white z-20 p-6 transform -translate-x-full transition-transform duration-300 lg:hidden">
    <div class="flex justify-between items-center mb-10">
        <div class="text-xl font-extrabold text-primary-blue tracking-wider">Instructor Panel</div>
        <button id="closeMobileMenu" class="text-3xl text-text-dark">&times;</button>
    </div>
    <nav class="space-y-4">
        <a href="<?php echo BASE_URL; ?>instructor/dashboard.php" class="block p-3 rounded-lg <?php echo $active_link === 'dashboard' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'dashboard' ? '🏠 Dashboard' : '🏠 Dashboard'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/courses/index.php" class="block p-3 rounded-lg <?php echo $active_link === 'courses' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'courses' ? '📚 My Courses' : '📚 My Courses'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/courses/new.php" class="block p-3 rounded-lg <?php echo $active_link === 'new_course' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'new_course' ? '➕ Create Course' : '➕ Create Course'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/questions/index.php" class="block p-3 rounded-lg <?php echo $active_link === 'questions' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'questions' ? '❓ Question Bank' : '❓ Question Bank'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/exams/index.php" class="block p-3 rounded-lg <?php echo $active_link === 'exams' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'exams' ? '📝 Exams & Quizzes' : '📝 Exams & Quizzes'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/exams/new.php" class="block p-3 rounded-lg <?php echo $active_link === 'new_exam' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'new_exam' ? '📋 Create Exam' : '📋 Create Exam'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/students.php" class="block p-3 rounded-lg <?php echo $active_link === 'students' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'students' ? '👥 My Students' : '👥 My Students'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/resources.php" class="block p-3 rounded-lg <?php echo $active_link === 'resources' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'resources' ? '📖 Resources' : '📖 Resources'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/assignments.php" class="block p-3 rounded-lg <?php echo $active_link === 'assignments' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'assignments' ? '📋 Assignments' : '📋 Assignments'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/analytics.php" class="block p-3 rounded-lg <?php echo $active_link === 'analytics' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'analytics' ? '📊 Analytics' : '📊 Analytics'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/student_progress.php" class="block p-3 rounded-lg <?php echo $active_link === 'student_progress' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'student_progress' ? '📈 Student Progress' : '📈 Student Progress'; ?></a>
        <a href="<?php echo BASE_URL; ?>instructor/grading/index.php" class="block p-3 rounded-lg <?php echo $active_link === 'grading' ? 'bg-primary-blue text-white font-semibold' : 'text-text-dark hover:bg-accent-subtle'; ?>"><?php echo $active_link === 'grading' ? '🏆 Grades' : '🏆 Grades'; ?></a>
        <a href="<?php echo BASE_URL; ?>logout.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle">🚪 Logout</a>
    </nav>
</div>