<?php
require_once 'config/database.php';
require_once 'config/auth.php';

try {
    $pdo = getDB();

    // Check if questions table exists and has data
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM questions");
    $count = $stmt->fetch()['count'];
    echo "Total questions: $count\n";

    if ($count > 0) {
        $stmt = $pdo->query("SELECT id, title, instructor_id, is_shared FROM questions LIMIT 5");
        $questions = $stmt->fetchAll();
        echo "Sample questions:\n";
        foreach ($questions as $q) {
            echo "- ID: {$q['id']}, Title: {$q['title']}, Instructor: {$q['instructor_id']}, Shared: {$q['is_shared']}\n";
        }
    }

    // Check session
    echo "Session user_id: " . ($_SESSION['user_id'] ?? 'not set') . "\n";
    echo "Session role: " . ($_SESSION['role'] ?? 'not set') . "\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>