
# Customer Response

Customer in merchant's or partner's system of records.

## Structure

`CustomerResponse`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | The unique ID for a customer generated by PayPal.<br><br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `22`, *Pattern*: `^[0-9a-zA-Z_-]+$` | getId(): ?string | setId(?string id): void |
| `merchantCustomerId` | `?string` | Optional | Merchants and partners may already have a data-store where their customer information is persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your representation of a customer.<br><br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `64`, *Pattern*: `^[0-9a-zA-Z-_.^*$@#]+$` | getMerchantCustomerId(): ?string | setMerchantCustomerId(?string merchantCustomerId): void |

## Example (as JSON)

```json
{
  "id": "id4",
  "merchant_customer_id": "merchant_customer_id6"
}
```

