<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayDecryptedTokenData;
use PaypalServerSdkLib\Models\ApplePayPaymentData;
use PaypalServerSdkLib\Models\ApplePayTokenizedCard;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model ApplePayDecryptedTokenData
 *
 * @see ApplePayDecryptedTokenData
 */
class ApplePayDecryptedTokenDataBuilder
{
    /**
     * @var ApplePayDecryptedTokenData
     */
    private $instance;

    private function __construct(ApplePayDecryptedTokenData $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Apple Pay Decrypted Token Data Builder object.
     *
     * @param ApplePayTokenizedCard $tokenizedCard
     */
    public static function init(ApplePayTokenizedCard $tokenizedCard): self
    {
        return new self(new ApplePayDecryptedTokenData($tokenizedCard));
    }

    /**
     * Sets transaction amount field.
     *
     * @param Money|null $value
     */
    public function transactionAmount(?Money $value): self
    {
        $this->instance->setTransactionAmount($value);
        return $this;
    }

    /**
     * Sets device manufacturer id field.
     *
     * @param string|null $value
     */
    public function deviceManufacturerId(?string $value): self
    {
        $this->instance->setDeviceManufacturerId($value);
        return $this;
    }

    /**
     * Sets payment data type field.
     *
     * @param string|null $value
     */
    public function paymentDataType(?string $value): self
    {
        $this->instance->setPaymentDataType($value);
        return $this;
    }

    /**
     * Sets payment data field.
     *
     * @param ApplePayPaymentData|null $value
     */
    public function paymentData(?ApplePayPaymentData $value): self
    {
        $this->instance->setPaymentData($value);
        return $this;
    }

    /**
     * Initializes a new Apple Pay Decrypted Token Data object.
     */
    public function build(): ApplePayDecryptedTokenData
    {
        return CoreHelper::clone($this->instance);
    }
}
