<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BalanceInformation;
use PaypalServerSdkLib\Models\BalancesResponse;

/**
 * Builder for model BalancesResponse
 *
 * @see BalancesResponse
 */
class BalancesResponseBuilder
{
    /**
     * @var BalancesResponse
     */
    private $instance;

    private function __construct(BalancesResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Balances Response Builder object.
     */
    public static function init(): self
    {
        return new self(new BalancesResponse());
    }

    /**
     * Sets balances field.
     *
     * @param BalanceInformation[]|null $value
     */
    public function balances(?array $value): self
    {
        $this->instance->setBalances($value);
        return $this;
    }

    /**
     * Sets account id field.
     *
     * @param string|null $value
     */
    public function accountId(?string $value): self
    {
        $this->instance->setAccountId($value);
        return $this;
    }

    /**
     * Sets as of time field.
     *
     * @param string|null $value
     */
    public function asOfTime(?string $value): self
    {
        $this->instance->setAsOfTime($value);
        return $this;
    }

    /**
     * Sets last refresh time field.
     *
     * @param string|null $value
     */
    public function lastRefreshTime(?string $value): self
    {
        $this->instance->setLastRefreshTime($value);
        return $this;
    }

    /**
     * Initializes a new Balances Response object.
     */
    public function build(): BalancesResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
