<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\CardResponseWithBillingAddress;

/**
 * Builder for model CardResponseWithBillingAddress
 *
 * @see CardResponseWithBillingAddress
 */
class CardResponseWithBillingAddressBuilder
{
    /**
     * @var CardResponseWithBillingAddress
     */
    private $instance;

    private function __construct(CardResponseWithBillingAddress $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Card Response With Billing Address Builder object.
     */
    public static function init(): self
    {
        return new self(new CardResponseWithBillingAddress());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets billing address field.
     *
     * @param Address|null $value
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Sets expiry field.
     *
     * @param string|null $value
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets currency code field.
     *
     * @param string|null $value
     */
    public function currencyCode(?string $value): self
    {
        $this->instance->setCurrencyCode($value);
        return $this;
    }

    /**
     * Initializes a new Card Response With Billing Address object.
     */
    public function build(): CardResponseWithBillingAddress
    {
        return CoreHelper::clone($this->instance);
    }
}
