<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExperienceContext;
use PaypalServerSdkLib\Models\IdealPaymentRequest;

/**
 * Builder for model IdealPaymentRequest
 *
 * @see IdealPaymentRequest
 */
class IdealPaymentRequestBuilder
{
    /**
     * @var IdealPaymentRequest
     */
    private $instance;

    private function __construct(IdealPaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Ideal Payment Request Builder object.
     *
     * @param string $name
     * @param string $countryCode
     */
    public static function init(string $name, string $countryCode): self
    {
        return new self(new IdealPaymentRequest($name, $countryCode));
    }

    /**
     * Sets bic field.
     *
     * @param string|null $value
     */
    public function bic(?string $value): self
    {
        $this->instance->setBic($value);
        return $this;
    }

    /**
     * Sets experience context field.
     *
     * @param ExperienceContext|null $value
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new Ideal Payment Request object.
     */
    public function build(): IdealPaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
