<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Level3CardProcessingData;
use PaypalServerSdkLib\Models\LineItem;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model Level3CardProcessingData
 *
 * @see Level3CardProcessingData
 */
class Level3CardProcessingDataBuilder
{
    /**
     * @var Level3CardProcessingData
     */
    private $instance;

    private function __construct(Level3CardProcessingData $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Level 3 Card Processing Data Builder object.
     */
    public static function init(): self
    {
        return new self(new Level3CardProcessingData());
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets duty amount field.
     *
     * @param Money|null $value
     */
    public function dutyAmount(?Money $value): self
    {
        $this->instance->setDutyAmount($value);
        return $this;
    }

    /**
     * Sets discount amount field.
     *
     * @param Money|null $value
     */
    public function discountAmount(?Money $value): self
    {
        $this->instance->setDiscountAmount($value);
        return $this;
    }

    /**
     * Sets shipping address field.
     *
     * @param Address|null $value
     */
    public function shippingAddress(?Address $value): self
    {
        $this->instance->setShippingAddress($value);
        return $this;
    }

    /**
     * Sets ships from postal code field.
     *
     * @param string|null $value
     */
    public function shipsFromPostalCode(?string $value): self
    {
        $this->instance->setShipsFromPostalCode($value);
        return $this;
    }

    /**
     * Sets line items field.
     *
     * @param LineItem[]|null $value
     */
    public function lineItems(?array $value): self
    {
        $this->instance->setLineItems($value);
        return $this;
    }

    /**
     * Initializes a new Level 3 Card Processing Data object.
     */
    public function build(): Level3CardProcessingData
    {
        return CoreHelper::clone($this->instance);
    }
}
