<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\MybankPaymentObject;

/**
 * Builder for model MybankPaymentObject
 *
 * @see MybankPaymentObject
 */
class MybankPaymentObjectBuilder
{
    /**
     * @var MybankPaymentObject
     */
    private $instance;

    private function __construct(MybankPaymentObject $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Mybank Payment Object Builder object.
     */
    public static function init(): self
    {
        return new self(new MybankPaymentObject());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets country code field.
     *
     * @param string|null $value
     */
    public function countryCode(?string $value): self
    {
        $this->instance->setCountryCode($value);
        return $this;
    }

    /**
     * Sets bic field.
     *
     * @param string|null $value
     */
    public function bic(?string $value): self
    {
        $this->instance->setBic($value);
        return $this;
    }

    /**
     * Sets iban last chars field.
     *
     * @param string|null $value
     */
    public function ibanLastChars(?string $value): self
    {
        $this->instance->setIbanLastChars($value);
        return $this;
    }

    /**
     * Initializes a new Mybank Payment Object object.
     */
    public function build(): MybankPaymentObject
    {
        return CoreHelper::clone($this->instance);
    }
}
