<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\NetworkTransaction;

/**
 * Builder for model NetworkTransaction
 *
 * @see NetworkTransaction
 */
class NetworkTransactionBuilder
{
    /**
     * @var NetworkTransaction
     */
    private $instance;

    private function __construct(NetworkTransaction $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Network Transaction Builder object.
     */
    public static function init(): self
    {
        return new self(new NetworkTransaction());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets date field.
     *
     * @param string|null $value
     */
    public function date(?string $value): self
    {
        $this->instance->setDate($value);
        return $this;
    }

    /**
     * Sets network field.
     *
     * @param string|null $value
     */
    public function network(?string $value): self
    {
        $this->instance->setNetwork($value);
        return $this;
    }

    /**
     * Sets acquirer reference number field.
     *
     * @param string|null $value
     */
    public function acquirerReferenceNumber(?string $value): self
    {
        $this->instance->setAcquirerReferenceNumber($value);
        return $this;
    }

    /**
     * Initializes a new Network Transaction object.
     */
    public function build(): NetworkTransaction
    {
        return CoreHelper::clone($this->instance);
    }
}
