<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingCycle;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\OrderBillingPlan;

/**
 * Builder for model OrderBillingPlan
 *
 * @see OrderBillingPlan
 */
class OrderBillingPlanBuilder
{
    /**
     * @var OrderBillingPlan
     */
    private $instance;

    private function __construct(OrderBillingPlan $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Billing Plan Builder object.
     *
     * @param BillingCycle[] $billingCycles
     */
    public static function init(array $billingCycles): self
    {
        return new self(new OrderBillingPlan($billingCycles));
    }

    /**
     * Sets setup fee field.
     *
     * @param Money|null $value
     */
    public function setupFee(?Money $value): self
    {
        $this->instance->setSetupFee($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Initializes a new Order Billing Plan object.
     */
    public function build(): OrderBillingPlan
    {
        return CoreHelper::clone($this->instance);
    }
}
