<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PayerName;

/**
 * Builder for model PayerName
 *
 * @see PayerName
 */
class PayerNameBuilder
{
    /**
     * @var PayerName
     */
    private $instance;

    private function __construct(PayerName $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payer Name Builder object.
     */
    public static function init(): self
    {
        return new self(new PayerName());
    }

    /**
     * Sets prefix field.
     *
     * @param string|null $value
     */
    public function prefix(?string $value): self
    {
        $this->instance->setPrefix($value);
        return $this;
    }

    /**
     * Sets given name field.
     *
     * @param string|null $value
     */
    public function givenName(?string $value): self
    {
        $this->instance->setGivenName($value);
        return $this;
    }

    /**
     * Sets surname field.
     *
     * @param string|null $value
     */
    public function surname(?string $value): self
    {
        $this->instance->setSurname($value);
        return $this;
    }

    /**
     * Sets middle name field.
     *
     * @param string|null $value
     */
    public function middleName(?string $value): self
    {
        $this->instance->setMiddleName($value);
        return $this;
    }

    /**
     * Sets suffix field.
     *
     * @param string|null $value
     */
    public function suffix(?string $value): self
    {
        $this->instance->setSuffix($value);
        return $this;
    }

    /**
     * Sets alternate full name field.
     *
     * @param string|null $value
     */
    public function alternateFullName(?string $value): self
    {
        $this->instance->setAlternateFullName($value);
        return $this;
    }

    /**
     * Sets full name field.
     *
     * @param string|null $value
     */
    public function fullName(?string $value): self
    {
        $this->instance->setFullName($value);
        return $this;
    }

    /**
     * Initializes a new Payer Name object.
     */
    public function build(): PayerName
    {
        return CoreHelper::clone($this->instance);
    }
}
