<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingPlan;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\PlanCollection;

/**
 * Builder for model PlanCollection
 *
 * @see PlanCollection
 */
class PlanCollectionBuilder
{
    /**
     * @var PlanCollection
     */
    private $instance;

    private function __construct(PlanCollection $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Plan Collection Builder object.
     */
    public static function init(): self
    {
        return new self(new PlanCollection());
    }

    /**
     * Sets plans field.
     *
     * @param BillingPlan[]|null $value
     */
    public function plans(?array $value): self
    {
        $this->instance->setPlans($value);
        return $this;
    }

    /**
     * Sets total items field.
     *
     * @param int|null $value
     */
    public function totalItems(?int $value): self
    {
        $this->instance->setTotalItems($value);
        return $this;
    }

    /**
     * Sets total pages field.
     *
     * @param int|null $value
     */
    public function totalPages(?int $value): self
    {
        $this->instance->setTotalPages($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Plan Collection object.
     */
    public function build(): PlanCollection
    {
        return CoreHelper::clone($this->instance);
    }
}
