<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The incentive details.
 */
class IncentiveDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $incentiveType;

    /**
     * @var string|null
     */
    private $incentiveCode;

    /**
     * @var Money|null
     */
    private $incentiveAmount;

    /**
     * @var string|null
     */
    private $incentiveProgramCode;

    /**
     * Returns Incentive Type.
     * The type of incentive, such as a special offer or coupon.
     */
    public function getIncentiveType(): ?string
    {
        return $this->incentiveType;
    }

    /**
     * Sets Incentive Type.
     * The type of incentive, such as a special offer or coupon.
     *
     * @maps incentive_type
     */
    public function setIncentiveType(?string $incentiveType): void
    {
        $this->incentiveType = $incentiveType;
    }

    /**
     * Returns Incentive Code.
     * The code that identifies an incentive, such as a coupon.
     */
    public function getIncentiveCode(): ?string
    {
        return $this->incentiveCode;
    }

    /**
     * Sets Incentive Code.
     * The code that identifies an incentive, such as a coupon.
     *
     * @maps incentive_code
     */
    public function setIncentiveCode(?string $incentiveCode): void
    {
        $this->incentiveCode = $incentiveCode;
    }

    /**
     * Returns Incentive Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getIncentiveAmount(): ?Money
    {
        return $this->incentiveAmount;
    }

    /**
     * Sets Incentive Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps incentive_amount
     */
    public function setIncentiveAmount(?Money $incentiveAmount): void
    {
        $this->incentiveAmount = $incentiveAmount;
    }

    /**
     * Returns Incentive Program Code.
     * The incentive program code that identifies a merchant loyalty or incentive program.
     */
    public function getIncentiveProgramCode(): ?string
    {
        return $this->incentiveProgramCode;
    }

    /**
     * Sets Incentive Program Code.
     * The incentive program code that identifies a merchant loyalty or incentive program.
     *
     * @maps incentive_program_code
     */
    public function setIncentiveProgramCode(?string $incentiveProgramCode): void
    {
        $this->incentiveProgramCode = $incentiveProgramCode;
    }

    /**
     * Converts the IncentiveDetails object to a human-readable string representation.
     *
     * @return string The string representation of the IncentiveDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'IncentiveDetails',
            [
                'incentiveType' => $this->incentiveType,
                'incentiveCode' => $this->incentiveCode,
                'incentiveAmount' => $this->incentiveAmount,
                'incentiveProgramCode' => $this->incentiveProgramCode
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->incentiveType)) {
            $json['incentive_type']         = $this->incentiveType;
        }
        if (isset($this->incentiveCode)) {
            $json['incentive_code']         = $this->incentiveCode;
        }
        if (isset($this->incentiveAmount)) {
            $json['incentive_amount']       = $this->incentiveAmount;
        }
        if (isset($this->incentiveProgramCode)) {
            $json['incentive_program_code'] = $this->incentiveProgramCode;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
