<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The level 2 card processing data collections. If your merchant account has been configured for Level
 * 2 processing this field will be passed to the processor on your behalf. Please contact your PayPal
 * Technical Account Manager to define level 2 data for your business.
 */
class Level2CardProcessingData implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $invoiceId;

    /**
     * @var Money|null
     */
    private $taxTotal;

    /**
     * Returns Invoice Id.
     * Use this field to pass a purchase identification value of up to 127 ASCII characters. The length of
     * this field will be adjusted to meet network specifications (25chars for Visa and Mastercard, 17chars
     * for Amex), and the original invoice ID will still be displayed in your existing reports.
     */
    public function getInvoiceId(): ?string
    {
        return $this->invoiceId;
    }

    /**
     * Sets Invoice Id.
     * Use this field to pass a purchase identification value of up to 127 ASCII characters. The length of
     * this field will be adjusted to meet network specifications (25chars for Visa and Mastercard, 17chars
     * for Amex), and the original invoice ID will still be displayed in your existing reports.
     *
     * @maps invoice_id
     */
    public function setInvoiceId(?string $invoiceId): void
    {
        $this->invoiceId = $invoiceId;
    }

    /**
     * Returns Tax Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTaxTotal(): ?Money
    {
        return $this->taxTotal;
    }

    /**
     * Sets Tax Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps tax_total
     */
    public function setTaxTotal(?Money $taxTotal): void
    {
        $this->taxTotal = $taxTotal;
    }

    /**
     * Converts the Level2CardProcessingData object to a human-readable string representation.
     *
     * @return string The string representation of the Level2CardProcessingData object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'Level2CardProcessingData',
            ['invoiceId' => $this->invoiceId, 'taxTotal' => $this->taxTotal]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->invoiceId)) {
            $json['invoice_id'] = $this->invoiceId;
        }
        if (isset($this->taxTotal)) {
            $json['tax_total']  = $this->taxTotal;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
