<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The response to a request to update the quantity of the product or service in a subscription. You
 * can also use this method to switch the plan and update the `shipping_amount` and `shipping_address`
 * values for the subscription. This type of update requires the buyer's consent.
 */
class ModifySubscriptionResponse implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $planId;

    /**
     * @var string|null
     */
    private $quantity;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var ShippingDetails|null
     */
    private $shippingAddress;

    /**
     * @var PlanOverride|null
     */
    private $plan;

    /**
     * @var bool|null
     */
    private $planOverridden;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Plan Id.
     * The unique PayPal-generated ID for the plan.
     */
    public function getPlanId(): ?string
    {
        return $this->planId;
    }

    /**
     * Sets Plan Id.
     * The unique PayPal-generated ID for the plan.
     *
     * @maps plan_id
     */
    public function setPlanId(?string $planId): void
    {
        $this->planId = $planId;
    }

    /**
     * Returns Quantity.
     * The quantity of the product or service in the subscription.
     */
    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    /**
     * Sets Quantity.
     * The quantity of the product or service in the subscription.
     *
     * @maps quantity
     */
    public function setQuantity(?string $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Shipping Address.
     * The shipping details.
     */
    public function getShippingAddress(): ?ShippingDetails
    {
        return $this->shippingAddress;
    }

    /**
     * Sets Shipping Address.
     * The shipping details.
     *
     * @maps shipping_address
     */
    public function setShippingAddress(?ShippingDetails $shippingAddress): void
    {
        $this->shippingAddress = $shippingAddress;
    }

    /**
     * Returns Plan.
     * An inline plan object to customise the subscription. You can override plan level default attributes
     * by providing customised values for the subscription in this object.
     */
    public function getPlan(): ?PlanOverride
    {
        return $this->plan;
    }

    /**
     * Sets Plan.
     * An inline plan object to customise the subscription. You can override plan level default attributes
     * by providing customised values for the subscription in this object.
     *
     * @maps plan
     */
    public function setPlan(?PlanOverride $plan): void
    {
        $this->plan = $plan;
    }

    /**
     * Returns Plan Overridden.
     * Indicates whether the subscription has overridden any plan attributes.
     */
    public function getPlanOverridden(): ?bool
    {
        return $this->planOverridden;
    }

    /**
     * Sets Plan Overridden.
     * Indicates whether the subscription has overridden any plan attributes.
     *
     * @maps plan_overridden
     */
    public function setPlanOverridden(?bool $planOverridden): void
    {
        $this->planOverridden = $planOverridden;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the ModifySubscriptionResponse object to a human-readable string representation.
     *
     * @return string The string representation of the ModifySubscriptionResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ModifySubscriptionResponse',
            [
                'planId' => $this->planId,
                'quantity' => $this->quantity,
                'shippingAmount' => $this->shippingAmount,
                'shippingAddress' => $this->shippingAddress,
                'plan' => $this->plan,
                'planOverridden' => $this->planOverridden,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->planId)) {
            $json['plan_id']          = $this->planId;
        }
        if (isset($this->quantity)) {
            $json['quantity']         = $this->quantity;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount']  = $this->shippingAmount;
        }
        if (isset($this->shippingAddress)) {
            $json['shipping_address'] = $this->shippingAddress;
        }
        if (isset($this->plan)) {
            $json['plan']             = $this->plan;
        }
        if (isset($this->planOverridden)) {
            $json['plan_overridden']  = $this->planOverridden;
        }
        if (isset($this->links)) {
            $json['links']            = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
